/*
 * Decompiled with CFR 0.152.
 */
package org.lanternpowered.lmbda;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.org.objectweb.asm.ClassReader;
import org.lanternpowered.lmbda.InternalUtilities;

final class InternalMethodHandles {
    static final @NonNull Adapter adapter = InternalMethodHandles.loadAdapter();

    InternalMethodHandles() {
    }

    private static @NonNull Adapter loadAdapter() {
        return AccessController.doPrivileged(() -> {
            if (InternalMethodHandles.isJava9Available()) {
                return new Java9Adapter();
            }
            return new Java8Adapter();
        });
    }

    private static boolean isJava9Available() {
        return InternalMethodHandles.findPrivateLookupMethodHandle() != null;
    }

    private static @Nullable MethodHandle findPrivateLookupMethodHandle() {
        try {
            return MethodHandles.publicLookup().findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    static /* synthetic */ MethodHandle access$000() {
        return InternalMethodHandles.findPrivateLookupMethodHandle();
    }

    static interface Adapter {
        public @NonNull MethodHandles.Lookup privateLookupIn(@NonNull Class<?> var1, @NonNull MethodHandles.Lookup var2) throws IllegalAccessException;

        public @NonNull Class<?> defineClass(@NonNull MethodHandles.Lookup var1, byte @NonNull [] var2) throws IllegalAccessException;
    }

    private static final class Java9Adapter
    implements Adapter {
        private static final @NonNull MethodHandle privateLookupMethodHandle = Objects.requireNonNull(InternalMethodHandles.access$000());
        private static final @NonNull MethodHandle defineClassMethodHandle = Java9Adapter.getDefineClassMethodHandle();

        private Java9Adapter() {
        }

        private static @NonNull MethodHandle getDefineClassMethodHandle() {
            return InternalUtilities.doUnchecked(() -> MethodHandles.publicLookup().findVirtual(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class)));
        }

        @Override
        public @NonNull MethodHandles.Lookup privateLookupIn(@NonNull Class<?> targetClass, @NonNull MethodHandles.Lookup lookup) {
            return InternalUtilities.doUnchecked(() -> privateLookupMethodHandle.invoke(targetClass, lookup));
        }

        @Override
        public @NonNull Class<?> defineClass(@NonNull MethodHandles.Lookup lookup, byte @NonNull [] byteCode) {
            return InternalUtilities.doUnchecked(() -> defineClassMethodHandle.invoke(lookup, byteCode));
        }
    }

    private static final class Java8Adapter
    implements Adapter {
        private static final @NonNull MethodHandles.Lookup trustedLookup = Java8Adapter.loadTrustedLookup();
        private static final @NonNull MethodHandle defineClassMethodHandle = Java8Adapter.getClassLoaderDefineMethodHandle();

        private Java8Adapter() {
        }

        private static @NonNull MethodHandle getClassLoaderDefineMethodHandle() {
            return InternalUtilities.doUnchecked(() -> trustedLookup.findVirtual(ClassLoader.class, "defineClass", MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class)));
        }

        private static @NonNull MethodHandles.Lookup loadTrustedLookup() {
            try {
                Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                field.setAccessible(true);
                return (MethodHandles.Lookup)field.get(null);
            }
            catch (NoSuchFieldException e) {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(Object.class);
                try {
                    Field field = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
                    field.setAccessible(true);
                    Field mField = Field.class.getDeclaredField("modifiers");
                    mField.setAccessible(true);
                    mField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                    Field trustedAccessModeField = MethodHandles.Lookup.class.getDeclaredField("TRUSTED");
                    trustedAccessModeField.setAccessible(true);
                    field.set(lookup, trustedAccessModeField.get(null));
                }
                catch (Exception e1) {
                    throw new IllegalStateException("Unable to create a trusted method handles lookup", e1);
                }
                return lookup;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to create a trusted method handles lookup", e);
            }
        }

        @Override
        public @NonNull MethodHandles.Lookup privateLookupIn(@NonNull Class<?> targetClass, @NonNull MethodHandles.Lookup lookup) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            if (targetClass.isPrimitive()) {
                throw new IllegalArgumentException(targetClass + " is a primitive class");
            }
            if (targetClass.isArray()) {
                throw new IllegalArgumentException(targetClass + " is an array class");
            }
            return trustedLookup.in(targetClass);
        }

        @Override
        public @NonNull Class<?> defineClass(@NonNull MethodHandles.Lookup lookup, byte @NonNull [] byteCode) {
            String className;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new ReflectPermission("defineClass"));
            }
            if ((lookup.lookupModes() & 8) == 0) {
                throw InternalUtilities.throwUnchecked(new IllegalAccessException("Lookup does not have PACKAGE access"));
            }
            try {
                ClassReader classReader = new ClassReader(byteCode);
                className = classReader.getClassName().replace('/', '.');
            }
            catch (RuntimeException e) {
                ClassFormatError classFormatError = new ClassFormatError();
                classFormatError.initCause(e);
                throw classFormatError;
            }
            Class<?> lookupClass = lookup.lookupClass();
            String packageName = InternalUtilities.getPackageName(className);
            String lookupPackageName = InternalUtilities.getPackageName(lookupClass);
            if (!packageName.equals(lookupPackageName)) {
                throw new IllegalArgumentException("Class not in same package as lookup class");
            }
            return AccessController.doPrivileged(() -> {
                ClassLoader classLoader = lookupClass.getClassLoader();
                ProtectionDomain protectionDomain = lookupClass.getProtectionDomain();
                return InternalUtilities.doUnchecked(() -> defineClassMethodHandle.invoke(classLoader, className, byteCode, 0, byteCode.length, protectionDomain));
            });
        }
    }
}

