/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity.integration;

import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import ua.nanit.limbo.NanoLimbo;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.data.InfoForwarding;
import xyz.kyngs.librelogin.common.integration.nanolimbo.NanoLimboIntegration;

public class VelocityNanoLimboIntegration
extends NanoLimboIntegration<RegisteredServer> {
    private final ClassLoader classLoader = NanoLimbo.class.getClassLoader();
    private final ProxyServer proxyServer;

    public VelocityNanoLimboIntegration(ProxyServer proxyServer, String portRange) {
        super(portRange);
        this.proxyServer = proxyServer;
    }

    @Override
    public RegisteredServer createLimbo(String serverName) {
        InetSocketAddress address = this.findLocalAvailableAddress().orElseThrow(() -> new IllegalStateException("Cannot find available port for limbo server!"));
        LimboServer server = this.createLimboServer(address);
        try {
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.proxyServer.registerServer(new ServerInfo(serverName, address));
    }

    @Override
    protected InfoForwarding createForwarding() {
        VelocityConfiguration velocityConfiguration = (VelocityConfiguration)this.proxyServer.getConfiguration();
        PlayerInfoForwarding forwardingMode = velocityConfiguration.getPlayerInfoForwardingMode();
        return switch (forwardingMode) {
            default -> throw new MatchException(null, null);
            case PlayerInfoForwarding.NONE -> FORWARDING_FACTORY.none();
            case PlayerInfoForwarding.LEGACY -> FORWARDING_FACTORY.legacy();
            case PlayerInfoForwarding.MODERN -> FORWARDING_FACTORY.modern(velocityConfiguration.getForwardingSecret());
            case PlayerInfoForwarding.BUNGEEGUARD -> FORWARDING_FACTORY.bungeeGuard(Collections.singleton(new String(velocityConfiguration.getForwardingSecret(), StandardCharsets.UTF_8)));
        };
    }

    @Override
    protected ClassLoader classLoader() {
        return this.classLoader;
    }
}

