/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.listener.AuthenticListeners;
import xyz.kyngs.librelogin.common.listener.PreLoginResult;
import xyz.kyngs.librelogin.common.listener.PreLoginState;
import xyz.kyngs.librelogin.common.util.GeneralUtil;
import xyz.kyngs.librelogin.velocity.VelocityLibreLogin;

public class VelocityListeners
extends AuthenticListeners<VelocityLibreLogin, Player, RegisteredServer> {
    private static final AttributeKey<?> FLOODGATE_ATTR = AttributeKey.valueOf((String)"floodgate-player");
    private static final Field INITIAL_MINECRAFT_CONNECTION;
    private static final Field INITIAL_CONNECTION_DELEGATE;
    private static final Field CHANNEL;

    public VelocityListeners(VelocityLibreLogin plugin) {
        super(plugin);
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPostLogin(PostLoginEvent event) {
        this.onPostLogin(event.getPlayer(), null);
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        this.onPlayerDisconnect(event.getPlayer());
    }

    @Subscribe(order=PostOrder.NORMAL)
    public void onProfileRequest(GameProfileRequestEvent event) {
        GameProfile existing = event.getGameProfile();
        if (existing != null && ((VelocityLibreLogin)this.plugin).fromFloodgate(existing.getId())) {
            return;
        }
        User profile = ((VelocityLibreLogin)this.plugin).getDatabaseProvider().getByName(event.getUsername());
        GameProfile gProfile = event.getOriginalProfile();
        event.setGameProfile(new GameProfile(profile.getUuid(), gProfile.getName(), gProfile.getProperties()));
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPreLogin(PreLoginEvent event) {
        if (!event.getResult().isAllowed()) {
            return;
        }
        if (((VelocityLibreLogin)this.plugin).floodgateEnabled()) {
            InboundConnection connection = event.getConnection();
            try {
                Object mcConnection;
                Channel channel;
                if (INITIAL_CONNECTION_DELEGATE != null) {
                    connection = (InboundConnection)INITIAL_CONNECTION_DELEGATE.get(connection);
                }
                if ((channel = (Channel)CHANNEL.get(mcConnection = INITIAL_MINECRAFT_CONNECTION.get(connection))).attr(FLOODGATE_ATTR).get() != null) {
                    return;
                }
            }
            catch (Exception e) {
                ((VelocityLibreLogin)this.plugin).getLogger().warn("Failed to check if player is coming from Floodgate.");
                e.printStackTrace();
                event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)"Internal LibreLogin error")));
                return;
            }
        }
        PreLoginResult result = this.onPreLogin(event.getUsername(), event.getConnection().getRemoteAddress().getAddress());
        event.setResult(switch (result.state()) {
            default -> throw new MatchException(null, null);
            case PreLoginState.DENIED -> {
                if (!$assertionsDisabled && result.message() == null) {
                    throw new AssertionError();
                }
                yield PreLoginEvent.PreLoginComponentResult.denied((Component)result.message());
            }
            case PreLoginState.FORCE_ONLINE -> PreLoginEvent.PreLoginComponentResult.forceOnlineMode();
            case PreLoginState.FORCE_OFFLINE -> PreLoginEvent.PreLoginComponentResult.forceOfflineMode();
        });
    }

    @Subscribe(order=PostOrder.LAST)
    public void chooseServer(PlayerChooseInitialServerEvent event) {
        BiHolder server = this.chooseServer(event.getPlayer(), null, null);
        if (server.value() == null) {
            event.getPlayer().disconnect((Component)((VelocityLibreLogin)this.plugin).getMessages().getMessage("kick-no-" + (server.key() != false ? "lobby" : "limbo"), new String[0]));
            event.setInitialServer(null);
        } else {
            event.setInitialServer((RegisteredServer)server.value());
        }
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onKick(KickedFromServerEvent event) {
        Component reason = (Component)event.getServerKickReason().orElse(Component.text((String)"null"));
        Component message = ((VelocityLibreLogin)this.plugin).getMessages().getMessage("info-kick", new String[0]).replaceText(builder -> builder.matchLiteral("%reason%").replacement((ComponentLike)reason));
        Player player = event.getPlayer();
        if (event.kickedDuringServerConnect()) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.Notify.create((Component)message));
        } else if (!((VelocityLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.FALLBACK).booleanValue() || ((VelocityLibreLogin)this.plugin).getServerHandler().getLobbyServers().containsValue((Object)event.getServer())) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)message));
        } else {
            try {
                RegisteredServer server = (RegisteredServer)((VelocityLibreLogin)this.plugin).getServerHandler().chooseLobbyServer(((VelocityLibreLogin)this.plugin).getDatabaseProvider().getByUUID(player.getUniqueId()), player, false, true);
                if (server == null) {
                    throw new NoSuchElementException();
                }
                event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)server, (Component)message));
            }
            catch (NoSuchElementException | EventCancelledException e) {
                event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)message));
            }
        }
    }

    static {
        try {
            Class<?> loginInboundConnection;
            Class<?> initialConnection = Class.forName("com.velocitypowered.proxy.connection.client.InitialInboundConnection");
            Class<?> minecraftConnection = Class.forName("com.velocitypowered.proxy.connection.MinecraftConnection");
            INITIAL_MINECRAFT_CONNECTION = GeneralUtil.getFieldByType(initialConnection, minecraftConnection);
            if (INITIAL_MINECRAFT_CONNECTION != null) {
                INITIAL_MINECRAFT_CONNECTION.setAccessible(true);
            }
            try {
                loginInboundConnection = Class.forName("com.velocitypowered.proxy.connection.client.LoginInboundConnection");
            }
            catch (ClassNotFoundException e) {
                loginInboundConnection = null;
            }
            if (loginInboundConnection != null) {
                INITIAL_CONNECTION_DELEGATE = loginInboundConnection.getDeclaredField("delegate");
                INITIAL_CONNECTION_DELEGATE.setAccessible(true);
                Objects.requireNonNull(INITIAL_CONNECTION_DELEGATE, "initial inbound connection delegate cannot be null");
            } else {
                INITIAL_CONNECTION_DELEGATE = null;
            }
            CHANNEL = GeneralUtil.getFieldByType(minecraftConnection, Channel.class);
            if (CHANNEL != null) {
                CHANNEL.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

