/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity;

import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.VelocityCommandIssuer;
import co.aikar.commands.VelocityCommandManager;
import com.google.inject.Inject;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.api.integration.LimboIntegration;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.SLF4JLogger;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.image.AuthenticImageProjector;
import xyz.kyngs.librelogin.common.image.protocolize.ProtocolizeImageProjector;
import xyz.kyngs.librelogin.common.util.CancellableTask;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.metrics.charts.CustomChart;
import xyz.kyngs.librelogin.lib.metrics.velocity.Metrics;
import xyz.kyngs.librelogin.velocity.VelocityBootstrap;
import xyz.kyngs.librelogin.velocity.VelocityPlatformHandle;
import xyz.kyngs.librelogin.velocity.VelocityRedisBungeeIntegration;
import xyz.kyngs.librelogin.velocity.integration.VelocityNanoLimboIntegration;

public class VelocityLibreLogin
extends AuthenticLibreLogin<Player, RegisteredServer> {
    private final VelocityBootstrap bootstrap;
    @Inject
    private Logger logger;
    @Inject
    @DataDirectory
    private Path dataDir;
    @Inject
    private ProxyServer server;
    @Inject
    private Metrics.Factory factory;
    @Inject
    private PluginDescription description;
    @Nullable
    private VelocityRedisBungeeIntegration redisBungee;
    @Nullable
    private LimboIntegration<RegisteredServer> limboIntegration;

    public VelocityLibreLogin(VelocityBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    protected void disable() {
        super.disable();
    }

    public ProxyServer getServer() {
        return this.server;
    }

    @Override
    protected PlatformHandle<Player, RegisteredServer> providePlatformHandle() {
        return new VelocityPlatformHandle(this);
    }

    @Override
    protected xyz.kyngs.librelogin.api.Logger provideLogger() {
        return new SLF4JLogger(this.logger, () -> this.getConfiguration().get(ConfigurationKeys.DEBUG));
    }

    @Override
    public CommandManager<?, ?, ?, ?, ?, ?> provideManager() {
        return new VelocityCommandManager(this.server, (Object)this.bootstrap);
    }

    @Override
    public Player getPlayerFromIssuer(CommandIssuer issuer) {
        return ((VelocityCommandIssuer)issuer).getPlayer();
    }

    @Override
    public void authorize(Player player, User user, Audience audience) {
        try {
            RegisteredServer lobby = (RegisteredServer)this.getServerHandler().chooseLobbyServer(user, player, true, false);
            if (lobby == null) {
                player.disconnect((Component)this.getMessages().getMessage("kick-no-lobby", new String[0]));
                return;
            }
            player.createConnectionRequest(lobby).connect().whenComplete((result, throwable) -> {
                if (player.getCurrentServer().isEmpty()) {
                    return;
                }
                if (((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName().equals(result.getAttemptedConnection().getServerInfo().getName())) {
                    return;
                }
                if (throwable != null || !result.isSuccessful()) {
                    player.disconnect((Component)Component.text((String)"Unable to connect"));
                }
            });
        }
        catch (EventCancelledException eventCancelledException) {
            // empty catch block
        }
    }

    @Override
    public CancellableTask delay(Runnable runnable, long delayInMillis) {
        ScheduledTask task = this.server.getScheduler().buildTask((Object)this.bootstrap, runnable).delay(delayInMillis, TimeUnit.MILLISECONDS).schedule();
        return () -> ((ScheduledTask)task).cancel();
    }

    @Override
    public CancellableTask repeat(Runnable runnable, long delayInMillis, long repeatInMillis) {
        ScheduledTask task = this.server.getScheduler().buildTask((Object)this.bootstrap, runnable).delay(delayInMillis, TimeUnit.MILLISECONDS).repeat(repeatInMillis, TimeUnit.MILLISECONDS).schedule();
        return () -> ((ScheduledTask)task).cancel();
    }

    @Override
    public boolean pluginPresent(String pluginName) {
        return this.server.getPluginManager().getPlugin(pluginName).isPresent();
    }

    @Override
    protected AuthenticImageProjector<Player, RegisteredServer> provideImageProjector() {
        if (this.pluginPresent("protocolize")) {
            ProtocolizeImageProjector<Player, RegisteredServer> projector = new ProtocolizeImageProjector<Player, RegisteredServer>(this);
            int maxProtocol = ProtocolVersion.MAXIMUM_VERSION.getProtocol();
            if (maxProtocol == 760) {
                try {
                    String[] split = this.server.getVersion().getVersion().split("-");
                    int build = Integer.parseInt(split[split.length - 1].replace("b", ""));
                    if (build < 172) {
                        this.logger.warn("Detected protocolize, but in order for the integration to work properly, you must be running Velocity build 172 or newer!");
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!projector.compatible()) {
                this.getLogger().warn("Detected protocolize, however, with incompatible version (2.2.2), please upgrade or downgrade.");
                return null;
            }
            this.getLogger().info("Detected Protocolize, enabling 2FA...");
            return projector;
        }
        this.logger.warn("Protocolize not found, some features (e.g. 2FA) will not work!");
        return null;
    }

    @Override
    protected void enable() {
        if (this.pluginPresent("redisbungee")) {
            this.redisBungee = new VelocityRedisBungeeIntegration();
        }
        super.enable();
        this.getLogger().info("LibreLogin version " + this.getVersion() + " enabled!");
    }

    @Override
    public String getVersion() {
        return (String)this.description.getVersion().orElseThrow();
    }

    @Override
    public boolean isPresent(UUID uuid) {
        return this.redisBungee != null ? this.redisBungee.isPlayerOnline(uuid) : this.getPlayerForUUID(uuid) != null;
    }

    @Override
    public boolean multiProxyEnabled() {
        return this.redisBungee != null;
    }

    @Override
    public Player getPlayerForUUID(UUID uuid) {
        return this.server.getPlayer(uuid).orElse(null);
    }

    @Override
    protected void initMetrics(CustomChart ... charts) {
        Metrics metrics = this.factory.make((Object)this.bootstrap, 17981);
        for (CustomChart chart : charts) {
            metrics.addCustomChart(chart);
        }
    }

    @Override
    public Audience getAudienceFromIssuer(CommandIssuer issuer) {
        return ((VelocityCommandIssuer)issuer).getIssuer();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    @Override
    public File getDataFolder() {
        return this.dataDir.toFile();
    }

    @Override
    @Nullable
    public LimboIntegration<RegisteredServer> getLimboIntegration() {
        if (this.pluginPresent("nanolimbovelocity") && this.limboIntegration == null) {
            this.limboIntegration = new VelocityNanoLimboIntegration(this.server, this.getConfiguration().get(ConfigurationKeys.LIMBO_PORT_RANGE));
        }
        return this.limboIntegration;
    }

    static {
        System.setProperty("auth.forceSecureProfiles", "false");
    }
}

