/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.provider.LibreLoginProvider;
import xyz.kyngs.librelogin.lib.libby.VelocityLibraryManager;
import xyz.kyngs.librelogin.velocity.Blockers;
import xyz.kyngs.librelogin.velocity.VelocityLibreLogin;
import xyz.kyngs.librelogin.velocity.VelocityListeners;

@Plugin(id="librelogin", name="LibreLogin", version="0.24.0", authors={"kyngs"}, dependencies={@Dependency(id="floodgate", optional=true), @Dependency(id="luckperms", optional=true), @Dependency(id="protocolize", optional=true), @Dependency(id="redisbungee", optional=true), @Dependency(id="nanolimbovelocity", optional=true)})
public class VelocityBootstrap
implements LibreLoginProvider<Player, RegisteredServer> {
    ProxyServer server;
    private final VelocityLibreLogin libreLogin;

    @Inject
    public VelocityBootstrap(ProxyServer server, Injector injector, Logger logger, final PluginContainer container) {
        this.server = server;
        VelocityLibraryManager<1> libraryManager = new VelocityLibraryManager<1>(logger, Path.of("plugins", "librelogin"), server.getPluginManager(), new PluginContainer(){

            public PluginDescription getDescription() {
                return container.getDescription();
            }

            public Optional<?> getInstance() {
                return Optional.of(this);
            }

            public ExecutorService getExecutorService() {
                return Executors.newSingleThreadExecutor();
            }
        });
        logger.info("Loading libraries...");
        libraryManager.configureFromJSON();
        this.libreLogin = new VelocityLibreLogin(this);
        injector.injectMembers((Object)this.libreLogin);
    }

    @Subscribe
    public void onInitialization(ProxyInitializeEvent event) {
        this.libreLogin.enable();
        this.server.getEventManager().register((Object)this, (Object)new Blockers(this.libreLogin.getAuthorizationProvider(), this.libreLogin.getConfiguration(), this.libreLogin.getMessages()));
        this.server.getEventManager().register((Object)this, (Object)new VelocityListeners(this.libreLogin));
    }

    @Override
    public LibreLoginPlugin<Player, RegisteredServer> getLibreLogin() {
        return this.libreLogin;
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.libreLogin.disable();
    }
}

