/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.configuration.Messages;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.HoconPluginConfiguration;

public class Blockers {
    private final AuthorizationProvider<Player> authorizationProvider;
    private final HoconPluginConfiguration configuration;

    public Blockers(AuthorizationProvider<Player> authorizationProvider, HoconPluginConfiguration configuration, Messages messages) {
        this.authorizationProvider = authorizationProvider;
        this.configuration = configuration;
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onChat(PlayerChatEvent event) {
        if (!this.authorizationProvider.isAuthorized(event.getPlayer()) || this.authorizationProvider.isAwaiting2FA(event.getPlayer())) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
        }
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onCommand(CommandExecuteEvent event) {
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        if (this.authorizationProvider.isAuthorized(player) && !this.authorizationProvider.isAwaiting2FA(player)) {
            return;
        }
        String command = event.getCommand().split(" ")[0];
        for (String allowed : this.configuration.get(ConfigurationKeys.ALLOWED_COMMANDS_WHILE_UNAUTHORIZED)) {
            if (!command.equals(allowed)) continue;
            return;
        }
        event.setResult(CommandExecuteEvent.CommandResult.denied());
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onServerConnect(ServerPreConnectEvent event) {
        if (this.authorizationProvider.isAwaiting2FA(event.getPlayer()) && !this.configuration.get(ConfigurationKeys.LIMBO).contains(event.getOriginalServer().getServerInfo().getName())) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onServerKick(KickedFromServerEvent event) {
        if (!this.authorizationProvider.isAuthorized(event.getPlayer()) || this.authorizationProvider.isAwaiting2FA(event.getPlayer())) {
            event.getPlayer().disconnect((Component)event.getServerKickReason().orElse(Component.text((String)"Limbo not running")));
        }
    }
}

