/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper.protocol;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import xyz.kyngs.librelogin.paper.PaperBootstrap;
import xyz.kyngs.librelogin.paper.protocol.ClientPublicKey;

public final class EncryptionUtil {
    public static final int VERIFY_TOKEN_LENGTH = 4;
    public static final String KEY_PAIR_ALGORITHM = "RSA";
    private static final int RSA_LENGTH = 1024;
    private static final PublicKey MOJANG_SESSION_KEY;
    private static final int LINE_LENGTH = 76;
    private static final Base64.Encoder KEY_ENCODER;
    private static final int MILLISECOND_SIZE = 8;
    private static final int UUID_SIZE = 16;

    private EncryptionUtil() {
        throw new RuntimeException("No instantiation of utility classes allowed");
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_PAIR_ALGORITHM);
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException nosuchalgorithmexception) {
            throw new ExceptionInInitializerError(nosuchalgorithmexception);
        }
    }

    public static byte[] generateVerifyToken(Random random) {
        byte[] token = new byte[4];
        random.nextBytes(token);
        return token;
    }

    public static String getServerIdHashString(String serverId, SecretKey sharedSecret, PublicKey publicKey) {
        byte[] serverHash = EncryptionUtil.getServerIdHash(serverId, publicKey, sharedSecret);
        return new BigInteger(serverHash).toString(16);
    }

    public static SecretKey decryptSharedKey(PrivateKey privateKey, byte[] sharedKey) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        return new SecretKeySpec(EncryptionUtil.decrypt(privateKey, sharedKey), "AES");
    }

    public static boolean verifyClientKey(ClientPublicKey clientKey, Instant verifyTimestamp, UUID premiumId) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (clientKey.expired(verifyTimestamp)) {
            return false;
        }
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(MOJANG_SESSION_KEY);
        verifier.update(EncryptionUtil.toSignable(clientKey, premiumId));
        return verifier.verify(clientKey.signature());
    }

    private static byte[] toSignable(ClientPublicKey clientPublicKey, UUID ownerPremiumId) {
        if (ownerPremiumId == null) {
            long expiry = clientPublicKey.expire().toEpochMilli();
            String encoded = KEY_ENCODER.encodeToString(clientPublicKey.key().getEncoded());
            return (expiry + "-----BEGIN RSA PUBLIC KEY-----\n" + encoded + "\n-----END RSA PUBLIC KEY-----\n").getBytes(StandardCharsets.US_ASCII);
        }
        byte[] keyData = clientPublicKey.key().getEncoded();
        return ByteBuffer.allocate(keyData.length + 16 + 8).putLong(ownerPremiumId.getMostSignificantBits()).putLong(ownerPremiumId.getLeastSignificantBits()).putLong(clientPublicKey.expire().toEpochMilli()).put(keyData).array();
    }

    public static boolean verifyNonce(byte[] expected, PrivateKey decryptionKey, byte[] encryptedNonce) throws NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] decryptedNonce = EncryptionUtil.decrypt(decryptionKey, encryptedNonce);
        return Arrays.equals(expected, decryptedNonce);
    }

    public static boolean verifySignedNonce(byte[] nonce, PublicKey clientKey, long signatureSalt, byte[] signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature verifier = Signature.getInstance("SHA256withRSA");
        verifier.initVerify(clientKey);
        verifier.update(nonce);
        verifier.update(Longs.toByteArray((long)signatureSalt));
        return verifier.verify(signature);
    }

    private static PublicKey loadMojangSessionKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        URL keyUrl = PaperBootstrap.class.getClassLoader().getResource("yggdrasil_session_pubkey.der");
        byte[] keyData = Resources.toByteArray((URL)keyUrl);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyData);
        return KeyFactory.getInstance(KEY_PAIR_ALGORITHM).generatePublic(keySpec);
    }

    private static byte[] decrypt(PrivateKey key, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    private static byte[] getServerIdHash(String sessionId, PublicKey publicKey, SecretKey sharedSecret) {
        Hasher hasher = Hashing.sha1().newHasher();
        hasher.putBytes(sessionId.getBytes(StandardCharsets.ISO_8859_1));
        hasher.putBytes(sharedSecret.getEncoded());
        hasher.putBytes(publicKey.getEncoded());
        return hasher.hash().asBytes();
    }

    static {
        KEY_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
        try {
            MOJANG_SESSION_KEY = EncryptionUtil.loadMojangSessionKey();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load Mojang session key", ex);
        }
    }
}

