/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.server.ServerPing;
import xyz.kyngs.librelogin.paper.PaperLibreLogin;
import xyz.kyngs.librelogin.paper.PaperUtil;

public class PaperPlatformHandle
implements PlatformHandle<Player, World> {
    private final PaperLibreLogin plugin;

    public PaperPlatformHandle(PaperLibreLogin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Audience getAudienceForPlayer(Player player) {
        return player;
    }

    @Override
    public UUID getUUIDForPlayer(Player player) {
        return player.getUniqueId();
    }

    @Override
    public CompletableFuture<Throwable> movePlayer(Player player, World to) {
        return player.teleportAsync(to.getSpawnLocation()).thenApply(success -> success != false ? null : new RuntimeException("Unknown cause"));
    }

    @Override
    public void kick(Player player, Component reason) {
        PaperUtil.runSyncAndWait(() -> player.kick(reason), this.plugin);
    }

    @Override
    public World getServer(String name, boolean limbo) {
        World world = Bukkit.getWorld((String)name);
        if (world != null) {
            return world;
        }
        File file = new File(name);
        boolean exists = file.exists();
        if (exists) {
            this.plugin.getLogger().info("Found world file for " + name + ", loading...");
        } else {
            this.plugin.getLogger().info("World file for " + name + " not found, creating...");
        }
        WorldCreator creator = new WorldCreator(name);
        if (limbo) {
            creator.generator("librelogin:void");
        }
        world = Bukkit.createWorld((WorldCreator)creator);
        if (limbo) {
            world.setSpawnLocation(new Location(world, 0.5, (double)(world.getHighestBlockYAt(0, 0) + 1), 0.5));
            world.setKeepSpawnInMemory(true);
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
        }
        return world;
    }

    @Override
    public Class<World> getServerClass() {
        return World.class;
    }

    @Override
    public Class<Player> getPlayerClass() {
        return Player.class;
    }

    @Override
    public String getIP(Player player) {
        return player.getAddress().getAddress().getHostAddress();
    }

    @Override
    public ServerPing ping(World server) {
        return new ServerPing(Integer.MAX_VALUE);
    }

    @Override
    public Collection<World> getServers() {
        return Bukkit.getWorlds();
    }

    @Override
    public String getServerName(World server) {
        return server.getName();
    }

    @Override
    public int getConnectedPlayers(World server) {
        return server.getPlayerCount();
    }

    @Override
    public String getPlayersServerName(Player player) {
        return player.getWorld().getName();
    }

    @Override
    public String getPlayersVirtualHost(Player player) {
        return null;
    }

    @Override
    public String getUsernameForPlayer(Player player) {
        return player.getName();
    }

    @Override
    public String getPlatformIdentifier() {
        return "paper";
    }

    @Override
    public PlatformHandle.ProxyData getProxyData() {
        return new PlatformHandle.ProxyData(Bukkit.getName() + " " + Bukkit.getVersion(), this.getServers().stream().map(this::fromWorld).toList(), Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(plugin -> MoreObjects.toStringHelper((Object)plugin).add("name", (Object)plugin.getName()).add("version", (Object)plugin.getDescription().getVersion()).add("authors", (Object)plugin.getDescription().getAuthors()).toString()).toList(), this.plugin.getServerHandler().getLimboServers().stream().map(this::fromWorld).toList(), this.plugin.getServerHandler().getLobbyServers().values().stream().map(this::fromWorld).toList());
    }

    private String fromWorld(World world) {
        return MoreObjects.toStringHelper((Object)world).add("name", (Object)world.getName()).add("environment", (Object)world.getEnvironment()).add("difficulty", (Object)world.getDifficulty()).add("players", world.getPlayers().size()).toString();
    }
}

