/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.kyngs.librelogin.api.provider.LibreLoginProvider;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.NotNull;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.libby.BukkitLibraryManager;
import xyz.kyngs.librelogin.lib.libby.LibraryManager;
import xyz.kyngs.librelogin.lib.libby.PaperLibraryManager;
import xyz.kyngs.librelogin.paper.PaperLibreLogin;
import xyz.kyngs.librelogin.paper.VoidWorldGenerator;

public class PaperBootstrap
extends JavaPlugin
implements LibreLoginProvider<Player, World> {
    private PaperLibreLogin libreLogin;

    @Nullable
    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, @Nullable String id) {
        return id == null ? null : (id.equals("void") ? new VoidWorldGenerator() : null);
    }

    public void onLoad() {
        LibraryManager libraryManager;
        this.getLogger().info("Analyzing server setup...");
        try {
            Class<Player> adventureClass = Class.forName("net.kyori.adventure.audience.Audience");
            if (!adventureClass.isAssignableFrom(Player.class)) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            this.unsupportedSetup();
        }
        this.getLogger().info("Detected Adventure-compatible server distribution - " + this.getServer().getName() + " " + this.getServer().getVersion());
        try {
            Class.forName("io.papermc.paper.plugin.entrypoint.classloader.PaperPluginClassLoader");
            libraryManager = new PaperLibraryManager((Plugin)this);
        }
        catch (ClassNotFoundException e) {
            libraryManager = new BukkitLibraryManager((Plugin)this);
        }
        this.getSLF4JLogger().info("Loading libraries...");
        try {
            libraryManager.configureFromJSON();
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Failed to load libraries, stopping server to prevent damage", (Throwable)e);
            this.stopServer();
        }
        this.libreLogin = new PaperLibreLogin(this);
    }

    public void onEnable() {
        this.getLogger().info("Bootstrapping LibreLogin...");
        this.libreLogin.enable();
    }

    private void unsupportedSetup() {
        this.getLogger().severe("***********************************************************");
        this.getLogger().severe("Detected an unsupported server distribution. Please use Paper or its forks. SPIGOT IS NOT SUPPORTED!");
        this.getLogger().severe("***********************************************************");
        this.stopServer();
    }

    private void stopServer() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(1);
    }

    public void onDisable() {
        this.libreLogin.disable();
    }

    public PaperLibreLogin getLibreLogin() {
        return this.libreLogin;
    }

    protected void disable() {
        this.setEnabled(false);
    }
}

