/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.paper;

import io.papermc.paper.event.player.AsyncChatEvent;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.projectiles.ProjectileSource;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.api.server.ServerHandler;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.HoconPluginConfiguration;
import xyz.kyngs.librelogin.paper.PaperLibreLogin;

public class Blockers
implements Listener {
    private final AuthorizationProvider<Player> authorizationProvider;
    private final HoconPluginConfiguration configuration;
    private final ServerHandler<Player, World> serverHandler;

    public Blockers(PaperLibreLogin plugin) {
        this.authorizationProvider = plugin.getAuthorizationProvider();
        this.configuration = plugin.getConfiguration();
        this.serverHandler = plugin.getServerHandler();
    }

    private <E extends PlayerEvent> void cancelIfNeeded(E event) {
        this.cancelIfNeeded(event.getPlayer(), (Cancellable)event);
    }

    private void cancelIfNeeded(Player player, Cancellable cancellable) {
        if (this.inLimbo(player)) {
            cancellable.setCancelled(true);
        }
    }

    private boolean inLimbo(Player player) {
        return !this.authorizationProvider.isAuthorized(player) || this.authorizationProvider.isAwaiting2FA(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onTeleport(PlayerTeleportEvent event) {
        if (this.inLimbo(event.getPlayer())) {
            event.setCancelled(true);
        } else if (this.serverHandler.getLimboServers().contains(event.getTo().getWorld()) && !event.getPlayer().hasPermission("librelogin.limbo.access")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncChatEvent event) {
        this.cancelIfNeeded(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (this.authorizationProvider.isAuthorized(event.getPlayer()) && !this.authorizationProvider.isAwaiting2FA(event.getPlayer())) {
            return;
        }
        String command = event.getMessage().substring(1).split(" ")[0];
        for (String allowed : this.configuration.get(ConfigurationKeys.ALLOWED_COMMANDS_WHILE_UNAUTHORIZED)) {
            if (!command.equals(allowed)) continue;
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        this.cancelIfNeeded(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        this.cancelIfNeeded(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.cancelIfNeeded(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.cancelIfNeeded(player, (Cancellable)event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent event) {
        this.cancelIfNeeded(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityTarget(EntityTargetEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.cancelIfNeeded(player, (Cancellable)event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            this.cancelIfNeeded(player, (Cancellable)event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onShootBow(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.cancelIfNeeded(player, (Cancellable)event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        if (this.inLimbo(event.getPlayer())) {
            event.getPlayer().setInvisible(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDrop(PlayerDropItemEvent event) {
        this.cancelIfNeeded(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            this.cancelIfNeeded(player, (Cancellable)event);
        }
    }
}

