/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;

public class RateLimiter<T> {
    private final Cache<T, Object> expiring;

    public RateLimiter(long amount, TimeUnit unit) {
        this.expiring = Caffeine.newBuilder().expireAfterWrite(amount, unit).build();
    }

    public boolean tryAndLimit(T t) {
        AtomicBoolean wasLimited = new AtomicBoolean(true);
        this.expiring.get(t, x -> {
            wasLimited.set(false);
            return new Object();
        });
        return wasLimited.get();
    }
}

