/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.totp;

import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.CodeVerifier;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.exceptions.QrGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.qr.ZxingPngQrGenerator;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.secret.SecretGenerator;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.totp.TOTPData;
import xyz.kyngs.librelogin.api.totp.TOTPProvider;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;

public class AuthenticTOTPProvider
implements TOTPProvider {
    private final AuthenticLibreLogin<?, ?> plugin;
    private final SecretGenerator secretGenerator;
    private final ZxingPngQrGenerator qrGenerator;
    private final CodeVerifier verifier;

    public AuthenticTOTPProvider(AuthenticLibreLogin<?, ?> plugin) {
        this.plugin = plugin;
        this.secretGenerator = new DefaultSecretGenerator();
        this.qrGenerator = new ZxingPngQrGenerator();
        this.qrGenerator.setImageSize(256);
        this.verifier = new DefaultCodeVerifier((CodeGenerator)new DefaultCodeGenerator(), (TimeProvider)new SystemTimeProvider());
    }

    @Override
    public TOTPData generate(User user) {
        return this.generate(user, this.secretGenerator.generate());
    }

    @Override
    public TOTPData generate(User user, String secret) {
        byte[] code;
        QrData data = new QrData.Builder().label(user.getLastNickname()).issuer(this.plugin.getConfiguration().get(ConfigurationKeys.TOTP_LABEL)).secret(secret).build();
        try {
            code = this.qrGenerator.generate(data);
        }
        catch (QrGenerationException e) {
            throw new RuntimeException(e);
        }
        try {
            return new TOTPData(ImageIO.read(new ByteArrayInputStream(code)), secret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(Integer code, String secret) {
        return this.verifier.isValidCode(secret, code.toString());
    }
}

