/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.api.server.ServerHandler;
import xyz.kyngs.librelogin.api.server.ServerPing;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticLimboServerChooseEvent;
import xyz.kyngs.librelogin.common.event.events.AuthenticLobbyServerChooseEvent;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;
import xyz.kyngs.librelogin.lib.caffeine.cache.LoadingCache;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public class AuthenticServerHandler<P, S>
implements ServerHandler<P, S> {
    private final LoadingCache<S, Optional<ServerPing>> pingCache;
    private final AuthenticLibreLogin<P, S> plugin;
    private final Collection<S> limboServers;
    private final Multimap<String, S> lobbyServers;

    public AuthenticServerHandler(AuthenticLibreLogin<P, S> plugin) {
        this.plugin = plugin;
        this.lobbyServers = HashMultimap.create();
        this.limboServers = new ArrayList<S>();
        this.pingCache = Caffeine.newBuilder().build(server -> {
            if (!plugin.getConfiguration().get(ConfigurationKeys.PING_SERVERS).booleanValue()) {
                return Optional.of(new ServerPing(Integer.MAX_VALUE));
            }
            plugin.getLogger().debug("Pinging server " + String.valueOf(server));
            ServerPing ping = plugin.getPlatformHandle().ping(server);
            plugin.getLogger().debug("Pinged server " + String.valueOf(server) + ": " + String.valueOf(ping));
            return Optional.ofNullable(plugin.getConfiguration().get(ConfigurationKeys.IGNORE_MAX_PLAYERS_FROM_BACKEND_PING) != false ? new ServerPing(Integer.MAX_VALUE) : ping);
        });
        plugin.repeat(() -> this.pingCache.refreshAll(this.pingCache.asMap().keySet()), 10000L, 10000L);
        PlatformHandle<P, S> handle = plugin.getPlatformHandle();
        if (plugin.getConfiguration().get(ConfigurationKeys.PING_SERVERS).booleanValue()) {
            plugin.getLogger().info("Pinging servers...");
        }
        for (String limbo : plugin.getConfiguration().get(ConfigurationKeys.LIMBO)) {
            S server2 = handle.getServer(limbo, true);
            if (server2 != null) {
                this.registerLimboServer(server2);
                continue;
            }
            plugin.getLogger().warn("Limbo server/world " + limbo + " not found!");
        }
        plugin.getConfiguration().get(ConfigurationKeys.LOBBY).forEach((forced, server) -> {
            Object s = handle.getServer((String)server, false);
            if (s != null) {
                this.registerLobbyServer(s, (String)forced);
            } else {
                plugin.getLogger().warn("Lobby server/world " + server + " not found!");
            }
        });
        plugin.getLogger().debug("List of registered servers: ");
        for (String server3 : plugin.getPlatformHandle().getServers()) {
            plugin.getLogger().debug("Server: " + plugin.getPlatformHandle().getServerName(server3) + " | " + String.valueOf(server3));
        }
        if (plugin.getConfiguration().get(ConfigurationKeys.PING_SERVERS).booleanValue()) {
            plugin.getLogger().info("Pinged servers...");
        }
    }

    @Override
    public ServerPing getLatestPing(S server) {
        return ((Optional)this.pingCache.get(server)).orElse(null);
    }

    @Override
    public S chooseLobbyServer(@Nullable User user, P player, boolean remember, boolean fallback) {
        return this.chooseLobbyServerInternal(user, player, remember, fallback);
    }

    public S chooseLobbyServerInternal(@Nullable User user, P player, boolean remember, Boolean fallback) {
        Collection servers;
        ServerPing ping;
        S server2;
        String last;
        if (user != null && remember && this.plugin.getConfiguration().get(ConfigurationKeys.REMEMBER_LAST_SERVER).booleanValue() && (last = user.getLastServer()) != null && (server2 = this.plugin.getPlatformHandle().getServer(last, false)) != null && (ping = this.getLatestPing(server2)) != null && ping.maxPlayers() > this.plugin.getPlatformHandle().getConnectedPlayers(server2)) {
            return server2;
        }
        AuthenticLobbyServerChooseEvent<P, S> event = new AuthenticLobbyServerChooseEvent<P, S>(user, player, this.plugin, fallback);
        ((AuthenticEventProvider)this.plugin.getEventProvider()).fire(this.plugin.getEventTypes().lobbyServerChoose, event);
        if (event.isCancelled()) {
            throw new EventCancelledException();
        }
        if (event.getServer() != null) {
            return event.getServer();
        }
        String virtual = this.plugin.getPlatformHandle().getPlayersVirtualHost(player);
        this.plugin.getLogger().debug("Virtual host for player " + this.plugin.getPlatformHandle().getUsernameForPlayer(player) + ": " + virtual);
        Collection collection = servers = virtual == null ? this.lobbyServers.get((Object)"root") : this.lobbyServers.get((Object)virtual);
        if (servers.isEmpty()) {
            servers = this.lobbyServers.get((Object)"root");
        }
        return servers.stream().filter(server -> {
            ServerPing ping = this.getLatestPing(server);
            return ping != null && ping.maxPlayers() > this.plugin.getPlatformHandle().getConnectedPlayers(server);
        }).min(Comparator.comparingInt(o -> this.plugin.getPlatformHandle().getConnectedPlayers(o))).orElse(null);
    }

    @Override
    public S chooseLobbyServer(@Nullable User user, P player, boolean remember) {
        return this.chooseLobbyServerInternal(user, player, remember, null);
    }

    @Override
    public S chooseLimboServer(User user, P player) {
        AuthenticLimboServerChooseEvent<P, S> event = new AuthenticLimboServerChooseEvent<P, S>(user, player, this.plugin);
        ((AuthenticEventProvider)this.plugin.getEventProvider()).fire(this.plugin.getEventTypes().limboServerChoose, event);
        if (event.getServer() != null) {
            return event.getServer();
        }
        return this.limboServers.stream().filter(server -> {
            ServerPing ping = this.getLatestPing(server);
            return ping != null && ping.maxPlayers() > this.plugin.getPlatformHandle().getConnectedPlayers(server);
        }).min(Comparator.comparingInt(o -> this.plugin.getPlatformHandle().getConnectedPlayers(o))).orElse(null);
    }

    @Override
    public Multimap<String, S> getLobbyServers() {
        return this.lobbyServers;
    }

    @Override
    public Collection<S> getLimboServers() {
        return this.limboServers;
    }

    @Override
    public void registerLobbyServer(S server, String forcedHost) {
        this.getLatestPing(server);
        this.lobbyServers.put((Object)forcedHost, server);
    }

    @Override
    public void registerLimboServer(S server) {
        this.getLatestPing(server);
        this.limboServers.add(server);
    }
}

