/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class NLoginSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public NLoginSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String uniqueIdString = rs.getString("unique_id");
                    String premiumIdString = rs.getString("mojang_id");
                    String lastNickname = rs.getString("last_name");
                    Timestamp lastSeen = rs.getTimestamp("last_seen");
                    Timestamp firstSeen = rs.getTimestamp("creation_date");
                    String rawPassword = rs.getString("password");
                    String ip = rs.getString("last_ip");
                    if (lastNickname == null || uniqueIdString == null) continue;
                    HashedPassword password = null;
                    if (rawPassword != null) {
                        if (rawPassword.startsWith("$SHA512$")) {
                            String[] split = rawPassword.substring(8).split("\\$");
                            password = new HashedPassword(split[0], split[1], "SHA-512");
                        } else if (rawPassword.startsWith("$2a$")) {
                            password = CryptoUtil.convertFromBCryptRaw(rawPassword);
                        } else {
                            this.logger.error("User %s has invalid algorithm %s, omitting".formatted(lastNickname, rawPassword));
                            continue;
                        }
                    }
                    users.add(new AuthenticUser(GeneralUtil.fromUnDashedUUID(uniqueIdString), premiumIdString == null ? null : GeneralUtil.fromUnDashedUUID(premiumIdString), password, lastNickname, firstSeen, lastSeen, null, ip, Timestamp.from(Instant.EPOCH), null, null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("Error while reading user from database");
                }
            }
            return users;
        });
    }
}

