/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class JPremiumSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public JPremiumSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    HashedPassword hashedPassword;
                    String[] split;
                    String uniqueIdString = rs.getString("uniqueId");
                    String premiumIdString = rs.getString("premiumId");
                    String lastNickname = rs.getString("lastNickname");
                    Timestamp lastSeen = rs.getTimestamp("lastSeen");
                    Timestamp firstSeen = rs.getTimestamp("firstSeen");
                    String rawPassword = rs.getString("hashedPassword");
                    if (lastNickname == null) continue;
                    String[] stringArray = split = rawPassword == null ? null : rawPassword.split("\\$");
                    if (rawPassword == null) {
                        hashedPassword = null;
                    } else {
                        switch (split[0]) {
                            case "SHA256": {
                                hashedPassword = new HashedPassword(split[2], split[1], "SHA-256");
                                break;
                            }
                            case "SHA512": {
                                hashedPassword = new HashedPassword(split[2], split[1], "SHA-512");
                                break;
                            }
                            case "BCRYPT": {
                                hashedPassword = CryptoUtil.convertFromBCryptRaw(rawPassword.replace("BCRYPT", "$2a"));
                                break;
                            }
                            default: {
                                this.logger.error("User %s has invalid algorithm %s, omitting".formatted(lastNickname, split[0]));
                                hashedPassword = null;
                            }
                        }
                    }
                    HashedPassword password = hashedPassword;
                    users.add(new AuthenticUser(GeneralUtil.fromUnDashedUUID(uniqueIdString), premiumIdString == null ? null : GeneralUtil.fromUnDashedUUID(premiumIdString), password, lastNickname, firstSeen, lastSeen, null, null, null, null, null));
                }
                catch (Exception e) {
                    this.logger.error("Failed to read user from JPremium db, omitting");
                }
            }
            return users;
        });
    }
}

