/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;

public class DBASQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public DBASQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    String name = rs.getString("name");
                    String hash = rs.getString("password");
                    String salt = rs.getString("salt");
                    HashedPassword password = hash != null && salt != null ? new HashedPassword(hash, salt, "SHA-512") : null;
                    users.add(new AuthenticUser(uuid, rs.getBoolean("premium") ? uuid : null, password, name, rs.getTimestamp("firstjoin"), rs.getTimestamp("lastjoin"), null, null, null, null, null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("Failed to read user from DBA db, omitting");
                }
            }
            return users;
        });
    }
}

