/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;

public class AuthySQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public AuthySQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    String uuid = rs.getString("uuid");
                    String username = rs.getString("username");
                    String ip = rs.getString("ip");
                    String passwordHash = rs.getString("password");
                    if (uuid == null || username == null) continue;
                    HashedPassword password = new HashedPassword(passwordHash, null, "SHA-256");
                    users.add(new AuthenticUser(UUID.fromString(uuid), null, password, username, Timestamp.from(Instant.now()), Timestamp.from(Instant.now()), null, ip, null, null, null));
                }
                catch (Exception e) {
                    this.logger.error("Error while migrating user from Authy db, omitting");
                }
            }
            return users;
        });
    }
}

