/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.migrate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.migrate.SQLMigrateReadProvider;
import xyz.kyngs.librelogin.common.util.CryptoUtil;

public class AegisSQLMigrateReadProvider
extends SQLMigrateReadProvider {
    public AegisSQLMigrateReadProvider(String tableName, Logger logger, SQLDatabaseConnector connector) {
        super(tableName, logger, connector);
    }

    @Override
    public Collection<User> getAllUsers() {
        return this.connector.runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM `%s`".formatted(this.tableName));
            ResultSet rs = ps.executeQuery();
            HashSet<AuthenticUser> users = new HashSet<AuthenticUser>();
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString("uuid").replace(".", ""));
                    String onlineID = rs.getString("onlineId");
                    String nickname = rs.getString("name");
                    String passwordRaw = rs.getString("password");
                    HashedPassword password = null;
                    if (passwordRaw != null && !passwordRaw.contentEquals("")) {
                        if (passwordRaw.startsWith("$2a$")) {
                            password = CryptoUtil.convertFromBCryptRaw(passwordRaw);
                        } else {
                            this.logger.error("User " + nickname + " has an invalid password hash");
                        }
                    }
                    users.add(new AuthenticUser(uuid, onlineID == null || !rs.getBoolean("premium") ? null : UUID.fromString(onlineID.replace(".", "")), password, nickname, Timestamp.valueOf(LocalDateTime.now()), Timestamp.valueOf(LocalDateTime.now()), null, null, null, null, null));
                }
                catch (Exception e) {
                    this.logger.error("Failed to read user from Aegis db, omitting");
                }
            }
            return users;
        });
    }
}

