/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.listener;

import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.event.events.AuthenticatedEvent;
import xyz.kyngs.librelogin.api.event.events.WrongPasswordEvent;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.lib.caffeine.cache.Cache;
import xyz.kyngs.librelogin.lib.caffeine.cache.Caffeine;

public class LoginTryListener<P, S> {
    private final AuthenticLibreLogin<P, S> plugin;
    private final Cache<P, Integer> loginTries;

    public LoginTryListener(AuthenticLibreLogin<P, S> libreLogin) {
        this.plugin = libreLogin;
        this.loginTries = Caffeine.newBuilder().expireAfterAccess((long)this.plugin.getConfiguration().get(ConfigurationKeys.MILLISECONDS_TO_EXPIRE_LOGIN_ATTEMPTS).intValue(), TimeUnit.MILLISECONDS).build();
        ((AuthenticEventProvider)libreLogin.getEventProvider()).subscribe(libreLogin.getEventTypes().wrongPassword, this::onWrongPassword);
        ((AuthenticEventProvider)libreLogin.getEventProvider()).subscribe(libreLogin.getEventTypes().authenticated, this::onAuthenticated);
    }

    private void onWrongPassword(WrongPasswordEvent<P, S> wrongPasswordEvent) {
        WrongPasswordEvent.AuthenticationSource source = wrongPasswordEvent.getSource();
        if (source != WrongPasswordEvent.AuthenticationSource.LOGIN && source != WrongPasswordEvent.AuthenticationSource.TOTP) {
            return;
        }
        if (this.plugin.getConfiguration().get(ConfigurationKeys.MAX_LOGIN_ATTEMPTS) == -1) {
            return;
        }
        int currentLoginTry = this.loginTries.asMap().merge(wrongPasswordEvent.getPlayer(), 1, Integer::sum);
        if (currentLoginTry >= this.plugin.getConfiguration().get(ConfigurationKeys.MAX_LOGIN_ATTEMPTS)) {
            String kickMessage = source == WrongPasswordEvent.AuthenticationSource.LOGIN ? "kick-error-password-wrong" : "kick-error-totp-wrong";
            this.plugin.getPlatformHandle().kick(wrongPasswordEvent.getPlayer(), (Component)this.plugin.getMessages().getMessage(kickMessage, new String[0]));
        }
    }

    private void onAuthenticated(AuthenticatedEvent<P, S> authenticatedEvent) {
        this.loginTries.invalidate(authenticatedEvent.getPlayer());
    }
}

