/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.listener;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.AuthenticatedEvent;
import xyz.kyngs.librelogin.api.premium.PremiumException;
import xyz.kyngs.librelogin.api.premium.PremiumUser;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.authorization.ProfileConflictResolutionStrategy;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticAuthenticatedEvent;
import xyz.kyngs.librelogin.common.listener.PreLoginResult;
import xyz.kyngs.librelogin.common.listener.PreLoginState;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public class AuthenticListeners<Plugin extends AuthenticLibreLogin<P, S>, P, S> {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]*");
    protected final Plugin plugin;
    protected final PlatformHandle<P, S> platformHandle;

    public AuthenticListeners(Plugin plugin) {
        this.plugin = plugin;
        this.platformHandle = ((AuthenticLibreLogin)plugin).getPlatformHandle();
    }

    protected void onPostLogin(P player, User user) {
        String ip = this.platformHandle.getIP(player);
        UUID uuid = this.platformHandle.getUUIDForPlayer(player);
        if (((AuthenticLibreLogin)this.plugin).fromFloodgate(uuid)) {
            return;
        }
        if (user == null) {
            user = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByUUID(uuid);
        }
        Duration sessionTime = Duration.ofSeconds(((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.SESSION_TIMEOUT));
        if (user.autoLoginEnabled()) {
            ((AuthenticLibreLogin)this.plugin).delay(() -> ((AuthenticLibreLogin)this.plugin).getPlatformHandle().getAudienceForPlayer(player).sendMessage((Component)((AuthenticLibreLogin)this.plugin).getMessages().getMessage("info-premium-logged-in", new String[0])), 500L);
            ((AuthenticEventProvider)((AuthenticLibreLogin)this.plugin).getEventProvider()).fire(this.plugin.getEventTypes().authenticated, new AuthenticAuthenticatedEvent(user, player, this.plugin, AuthenticatedEvent.AuthenticationReason.PREMIUM));
        } else if (sessionTime != null && user.getLastAuthentication() != null && ip.equals(user.getIp()) && user.getLastAuthentication().toLocalDateTime().plus(sessionTime).isAfter(LocalDateTime.now())) {
            ((AuthenticLibreLogin)this.plugin).delay(() -> ((AuthenticLibreLogin)this.plugin).getPlatformHandle().getAudienceForPlayer(player).sendMessage((Component)((AuthenticLibreLogin)this.plugin).getMessages().getMessage("info-session-logged-in", new String[0])), 500L);
            ((AuthenticEventProvider)((AuthenticLibreLogin)this.plugin).getEventProvider()).fire(this.plugin.getEventTypes().authenticated, new AuthenticAuthenticatedEvent(user, player, this.plugin, AuthenticatedEvent.AuthenticationReason.SESSION));
        } else {
            ((AuthenticAuthorizationProvider)((AuthenticLibreLogin)this.plugin).getAuthorizationProvider()).startTracking(user, player);
        }
        user.setLastSeen(Timestamp.valueOf(LocalDateTime.now()));
        User finalUser = user;
        ((AuthenticLibreLogin)this.plugin).delay(() -> ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().updateUser(finalUser), 0L);
    }

    protected void onPlayerDisconnect(P player) {
        ((AuthenticLibreLogin)this.plugin).onExit(player);
        ((AuthenticAuthorizationProvider)((AuthenticLibreLogin)this.plugin).getAuthorizationProvider()).onExit(player);
    }

    protected PreLoginResult onPreLogin(String username, InetAddress address) {
        PremiumUser mojangData;
        if (username.length() > 16 || !NAME_PATTERN.matcher(username).matches()) {
            return new PreLoginResult(PreLoginState.DENIED, (Component)((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-illegal-username", new String[0]), null);
        }
        try {
            mojangData = ((AuthenticLibreLogin)this.plugin).getPremiumProvider().getUserForName(username);
        }
        catch (PremiumException e) {
            TextComponent message = switch (e.getIssue()) {
                case PremiumException.Issue.THROTTLED -> ((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-premium-error-throttled", new String[0]);
                default -> {
                    ((AuthenticLibreLogin)this.plugin).getLogger().error("Encountered an exception while communicating with the Mojang API!");
                    e.printStackTrace();
                    yield ((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-premium-error-undefined", new String[0]);
                }
            };
            return new PreLoginResult(PreLoginState.DENIED, (Component)message, null);
        }
        if (mojangData == null) {
            User user;
            try {
                user = this.checkAndValidateByName(username, null, true, address);
            }
            catch (InvalidCommandArgument e) {
                return new PreLoginResult(PreLoginState.DENIED, (Component)e.getUserFuckUp(), null);
            }
            if (user.getPremiumUUID() != null) {
                return new PreLoginResult(PreLoginState.FORCE_ONLINE, null, user);
            }
        } else {
            UUID premiumID = mojangData.uuid();
            User user = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByPremiumUUID(premiumID);
            if (user == null) {
                User userByName;
                try {
                    userByName = this.checkAndValidateByName(username, mojangData, true, address);
                }
                catch (InvalidCommandArgument e) {
                    return new PreLoginResult(PreLoginState.DENIED, (Component)e.getUserFuckUp(), null);
                }
                if (userByName.autoLoginEnabled()) {
                    return new PreLoginResult(PreLoginState.FORCE_ONLINE, null, userByName);
                }
            } else {
                User byName;
                try {
                    byName = this.checkAndValidateByName(username, mojangData, false, address);
                }
                catch (InvalidCommandArgument e) {
                    return new PreLoginResult(PreLoginState.DENIED, (Component)e.getUserFuckUp(), null);
                }
                if (byName != null && !user.equals(byName)) {
                    return this.handleProfileConflict(user, byName);
                }
                if (!mojangData.reliable()) {
                    ((AuthenticLibreLogin)this.plugin).getLogger().warn("User %s has probably changed their name. Data returned from Mojang API is not reliable, faking a new one using the current nickname.".formatted(username));
                    mojangData = new PremiumUser(mojangData.uuid(), username, false);
                }
                if (!user.getLastNickname().contentEquals(mojangData.name())) {
                    user.setLastNickname(mojangData.name());
                    ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().updateUser(user);
                }
                return new PreLoginResult(PreLoginState.FORCE_ONLINE, null, user);
            }
        }
        return new PreLoginResult(PreLoginState.FORCE_OFFLINE, null, null);
    }

    private PreLoginResult handleProfileConflict(User conflicting, User conflicted) {
        return switch (ProfileConflictResolutionStrategy.valueOf(((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.PROFILE_CONFLICT_RESOLUTION_STRATEGY))) {
            default -> throw new MatchException(null, null);
            case ProfileConflictResolutionStrategy.BLOCK -> new PreLoginResult(PreLoginState.DENIED, (Component)((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-name-mismatch", "%nickname%", conflicting.getLastNickname()), null);
            case ProfileConflictResolutionStrategy.USE_OFFLINE -> new PreLoginResult(PreLoginState.FORCE_OFFLINE, null, null);
            case ProfileConflictResolutionStrategy.OVERWRITE -> {
                ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().deleteUser(conflicted);
                conflicting.setLastNickname(conflicted.getLastNickname());
                ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().updateUser(conflicting);
                yield new PreLoginResult(PreLoginState.FORCE_ONLINE, null, conflicting);
            }
        };
    }

    private User checkAndValidateByName(String username, @Nullable PremiumUser premiumUser, boolean generate, InetAddress ip) throws InvalidCommandArgument {
        User user = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByName(username);
        if (user != null) {
            if (!user.getLastNickname().contentEquals(username)) {
                throw new InvalidCommandArgument(((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-invalid-case-username", "%username%", user.getLastNickname()));
            }
        } else if (generate) {
            int ipCount;
            Integer minLength = ((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.MINIMUM_USERNAME_LENGTH);
            if (username.length() < minLength) {
                throw new InvalidCommandArgument(((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-short-username", "%length%", String.valueOf(minLength)));
            }
            Integer ipLimit = ((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.IP_LIMIT);
            if (ipLimit > 0 && (ipCount = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByIP(ip.getHostAddress()).size()) >= ipLimit) {
                throw new InvalidCommandArgument(((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-ip-limit", "%limit%", String.valueOf(ipLimit)));
            }
            UUID newID = ((AuthenticLibreLogin)this.plugin).generateNewUUID(username, premiumUser == null ? null : premiumUser.uuid());
            User conflictingUser = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByUUID(newID);
            if (conflictingUser != null) {
                throw new InvalidCommandArgument(((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-occupied-username", "%username%", conflictingUser.getLastNickname()));
            }
            if (premiumUser != null && premiumUser.reliable() && ((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.AUTO_REGISTER).booleanValue()) {
                if (!premiumUser.name().contentEquals(username)) {
                    throw new InvalidCommandArgument(((AuthenticLibreLogin)this.plugin).getMessages().getMessage("kick-invalid-case-username", "%username%", premiumUser.name()));
                }
                user = new AuthenticUser(newID, premiumUser.uuid(), null, username, Timestamp.valueOf(LocalDateTime.now()), Timestamp.valueOf(LocalDateTime.now()), null, ip.getHostAddress(), null, null, null);
            } else {
                if (premiumUser != null && !premiumUser.reliable()) {
                    ((AuthenticLibreLogin)this.plugin).getLogger().warn("The premium data for %s is not reliable, the user may not have the same name capitalization as the premium one. It is not safe to auto-register this user. Switching to offline registration!".formatted(username));
                }
                user = new AuthenticUser(newID, null, null, username, Timestamp.valueOf(LocalDateTime.now()), Timestamp.valueOf(LocalDateTime.now()), null, ip.getHostAddress(), null, null, null);
            }
            ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().insertUser(user);
        } else {
            return null;
        }
        return user;
    }

    protected BiHolder<Boolean, S> chooseServer(P player, @Nullable String ip, @Nullable User user) {
        UUID id = this.platformHandle.getUUIDForPlayer(player);
        boolean fromFloodgate = ((AuthenticLibreLogin)this.plugin).fromFloodgate(id);
        Duration sessionTime = Duration.ofSeconds(((AuthenticLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.SESSION_TIMEOUT));
        if (fromFloodgate) {
            user = null;
        } else if (user == null) {
            user = ((AuthenticLibreLogin)this.plugin).getDatabaseProvider().getByUUID(id);
        }
        if (ip == null) {
            ip = this.platformHandle.getIP(player);
        }
        if (fromFloodgate || user.autoLoginEnabled() || sessionTime != null && user.getLastAuthentication() != null && ip.equals(user.getIp()) && user.getLastAuthentication().toLocalDateTime().plus(sessionTime).isAfter(LocalDateTime.now())) {
            return new BiHolder(true, ((AuthenticLibreLogin)this.plugin).getServerHandler().chooseLobbyServer(user, player, true, false));
        }
        return new BiHolder(false, ((AuthenticLibreLogin)this.plugin).getServerHandler().chooseLimboServer(user, player));
    }
}

