/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.integration.nanolimbo;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.util.Optional;
import ua.nanit.limbo.configuration.LimboConfig;
import ua.nanit.limbo.server.CommandHandler;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.data.InfoForwarding;
import xyz.kyngs.librelogin.api.integration.LimboIntegration;
import xyz.kyngs.librelogin.common.integration.nanolimbo.DummyCommandHandler;
import xyz.kyngs.librelogin.common.integration.nanolimbo.InfoForwardingFactory;
import xyz.kyngs.librelogin.common.integration.nanolimbo.NanoLimboConfig;

public abstract class NanoLimboIntegration<S>
implements LimboIntegration<S> {
    protected static final InfoForwardingFactory FORWARDING_FACTORY = new InfoForwardingFactory();
    private final int portMin;
    private final int portMax;

    public NanoLimboIntegration(String portRange) {
        this.portMin = Integer.parseInt(portRange.split("-")[0]);
        this.portMax = Integer.parseInt(portRange.split("-")[1]);
    }

    protected LimboServer createLimboServer(SocketAddress address) {
        return new LimboServer((LimboConfig)new NanoLimboConfig(address, this.createForwarding()), (CommandHandler)new DummyCommandHandler(), this.classLoader());
    }

    protected abstract InfoForwarding createForwarding();

    protected abstract ClassLoader classLoader();

    protected Optional<InetSocketAddress> findLocalAvailableAddress() {
        int port = this.portMin;
        while (port <= this.portMax) {
            Optional<InetSocketAddress> optional;
            ServerSocket ignored = new ServerSocket(port);
            try {
                optional = Optional.of(new InetSocketAddress(port));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ++port;
                }
            }
            ignored.close();
            return optional;
        }
        return Optional.empty();
    }
}

