/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.integration.nanolimbo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import ua.nanit.limbo.server.data.InfoForwarding;

public class InfoForwardingFactory {
    public InfoForwarding none() {
        Map<String, InfoForwarding.Type> map = Map.of("type", InfoForwarding.Type.NONE);
        return this.createForwarding(map);
    }

    public InfoForwarding legacy() {
        Map<String, InfoForwarding.Type> map = Map.of("type", InfoForwarding.Type.LEGACY);
        return this.createForwarding(map);
    }

    public InfoForwarding modern(byte[] secretKey) {
        Map<String, byte[]> map = Map.of("type", InfoForwarding.Type.MODERN, "secretKey", secretKey);
        return this.createForwarding(map);
    }

    public InfoForwarding bungeeGuard(Collection<String> tokens) {
        Map<String, Object> map = Map.of("type", InfoForwarding.Type.BUNGEE_GUARD, "tokens", new ArrayList<String>(tokens));
        return this.createForwarding(map);
    }

    private InfoForwarding createForwarding(Map<String, Object> map) {
        InfoForwarding forwarding = new InfoForwarding();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Class<?> clazz = forwarding.getClass();
            try {
                Field field = clazz.getDeclaredField(entry.getKey());
                field.setAccessible(true);
                field.set(forwarding, entry.getValue());
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {}
        }
        return forwarding;
    }
}

