/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.image.protocolize.packet;

import dev.simplix.protocolize.api.PacketDirection;
import dev.simplix.protocolize.api.mapping.AbstractProtocolMapping;
import dev.simplix.protocolize.api.mapping.ProtocolIdMapping;
import dev.simplix.protocolize.api.packet.AbstractPacket;
import dev.simplix.protocolize.api.util.ProtocolUtil;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import xyz.kyngs.librelogin.common.image.protocolize.MapData;

public class MapDataPacket
extends AbstractPacket {
    public static final List<ProtocolIdMapping> MAPPINGS = Arrays.asList(AbstractProtocolMapping.rangedIdMapping((int)393, (int)498, (int)38), AbstractProtocolMapping.rangedIdMapping((int)573, (int)578, (int)39), AbstractProtocolMapping.rangedIdMapping((int)735, (int)736, (int)38), AbstractProtocolMapping.rangedIdMapping((int)751, (int)754, (int)37), AbstractProtocolMapping.rangedIdMapping((int)755, (int)758, (int)39), AbstractProtocolMapping.rangedIdMapping((int)759, (int)759, (int)36), AbstractProtocolMapping.rangedIdMapping((int)760, (int)760, (int)38), AbstractProtocolMapping.rangedIdMapping((int)761, (int)761, (int)37), AbstractProtocolMapping.rangedIdMapping((int)762, (int)763, (int)41), AbstractProtocolMapping.rangedIdMapping((int)764, (int)765, (int)42), AbstractProtocolMapping.rangedIdMapping((int)766, (int)767, (int)44));
    private int mapID;
    private byte scale;
    private MapData mapData;
    private boolean trackingPosition;
    private boolean locked;
    private IconData[] iconData;

    public MapDataPacket(int mapID, byte scale, MapData mapData) {
        this.mapID = mapID;
        this.scale = scale;
        this.mapData = mapData;
        this.trackingPosition = false;
        this.iconData = new IconData[0];
        this.locked = false;
    }

    public MapDataPacket() {
    }

    public void read(ByteBuf byteBuf, PacketDirection packetDirection, int protocol) {
        this.mapID = ProtocolUtil.readVarInt((ByteBuf)byteBuf);
        this.scale = byteBuf.readByte();
        if (protocol < 755) {
            this.trackingPosition = byteBuf.readBoolean();
            if (protocol >= 477) {
                this.locked = byteBuf.readBoolean();
            }
        } else {
            this.locked = byteBuf.readBoolean();
            this.trackingPosition = byteBuf.readBoolean();
        }
        this.iconData = new IconData[protocol < 755 || this.trackingPosition ? ProtocolUtil.readVarInt((ByteBuf)byteBuf) : 0];
        for (int i = 0; i < this.iconData.length; ++i) {
            this.iconData[i] = new IconData(ProtocolUtil.readVarInt((ByteBuf)byteBuf), byteBuf.readByte(), byteBuf.readByte(), byteBuf.readByte(), byteBuf.readBoolean() ? ProtocolUtil.readString((ByteBuf)byteBuf) : null);
        }
        short columns = byteBuf.readUnsignedByte();
        if (columns <= 0) {
            this.mapData = new MapData(0, 0, 0, 0, new byte[0]);
        } else {
            byte rows = byteBuf.readByte();
            byte x = byteBuf.readByte();
            byte y = byteBuf.readByte();
            byte[] data = ProtocolUtil.readByteArray((ByteBuf)byteBuf);
            this.mapData = new MapData(columns, rows, x, y, data);
        }
    }

    public void write(ByteBuf byteBuf, PacketDirection packetDirection, int protocol) {
        ProtocolUtil.writeVarInt((ByteBuf)byteBuf, (int)this.mapID);
        byteBuf.writeByte((int)this.scale);
        if (protocol < 755) {
            byteBuf.writeBoolean(this.trackingPosition);
            if (protocol >= 477) {
                byteBuf.writeBoolean(this.locked);
            }
        } else {
            byteBuf.writeBoolean(this.locked);
            byteBuf.writeBoolean(this.trackingPosition);
        }
        if (protocol < 755 || this.trackingPosition) {
            ProtocolUtil.writeVarInt((ByteBuf)byteBuf, (int)this.iconData.length);
            for (IconData icon : this.iconData) {
                ProtocolUtil.writeVarInt((ByteBuf)byteBuf, (int)icon.type);
                byteBuf.writeByte((int)icon.x);
                byteBuf.writeByte((int)icon.z);
                byteBuf.writeByte((int)icon.direction);
                if (icon.displayName != null) {
                    byteBuf.writeBoolean(true);
                    ProtocolUtil.writeString((ByteBuf)byteBuf, (String)icon.displayName);
                    continue;
                }
                byteBuf.writeBoolean(false);
            }
        }
        byteBuf.writeByte(this.mapData.columns());
        if (this.mapData.columns() > 0) {
            byteBuf.writeByte(this.mapData.rows());
            byteBuf.writeByte(this.mapData.posX());
            byteBuf.writeByte(this.mapData.posZ());
            ProtocolUtil.writeByteArray((ByteBuf)byteBuf, (byte[])this.mapData.data());
        }
    }

    private record IconData(int type, byte x, byte z, byte direction, String displayName) {
    }
}

