/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.event;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.PlayerBasedEvent;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public class AuthenticPlayerBasedEvent<P, S>
implements PlayerBasedEvent<P, S> {
    private final User user;
    private final Audience audience;
    private final UUID uuid;
    private final P player;
    private final LibreLoginPlugin<P, S> plugin;
    private final PlatformHandle<P, S> platformHandle;

    public AuthenticPlayerBasedEvent(@Nullable User user, @Nullable P player, LibreLoginPlugin<P, S> plugin) {
        this.plugin = plugin;
        this.platformHandle = plugin.getPlatformHandle();
        this.user = user;
        this.audience = player == null ? Audience.empty() : this.platformHandle.getAudienceForPlayer(player);
        this.uuid = player == null ? null : this.platformHandle.getUUIDForPlayer(player);
        this.player = player;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Audience getAudience() {
        return this.audience;
    }

    @Override
    public P getPlayer() {
        return this.player;
    }

    @Override
    public LibreLoginPlugin<P, S> getPlugin() {
        return this.plugin;
    }

    @Override
    public PlatformHandle<P, S> getPlatformHandle() {
        return this.platformHandle;
    }
}

