/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.event;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import xyz.kyngs.librelogin.api.event.Event;
import xyz.kyngs.librelogin.api.event.EventProvider;
import xyz.kyngs.librelogin.api.event.EventType;
import xyz.kyngs.librelogin.common.AuthenticHandler;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;

public class AuthenticEventProvider<P, S>
extends AuthenticHandler<P, S>
implements EventProvider<P, S> {
    private final Map<EventType<P, S, ?>, Set<Consumer<Event<P, S>>>> listeners = new ConcurrentHashMap();

    public AuthenticEventProvider(AuthenticLibreLogin<P, S> plugin) {
        super(plugin);
    }

    @Override
    public <E extends Event<P, S>> Consumer<E> subscribe(EventType<P, S, E> type, Consumer<E> handler) {
        this.listeners.computeIfAbsent(type, x -> new HashSet()).add(handler);
        return handler;
    }

    @Override
    public void unsubscribe(Consumer<? extends Event<P, S>> handler) {
        this.listeners.values().forEach(x -> x.remove(handler));
    }

    @Override
    public <E extends Event<P, S>> void fire(EventType<P, S, E> type, E event) {
        Set<Consumer<Event<P, S>>> set = this.listeners.get(type);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Consumer<Event<P, S>> consumer : set) {
            consumer.accept(event);
        }
    }

    public void unsafeFire(EventType<?, ?, ?> type, Event<?, ?> event) {
        Set<Consumer<Event<P, S>>> set = this.listeners.get(type);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (Consumer<Event<P, S>> consumer : set) {
            consumer.accept(event);
        }
    }
}

