/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.database.provider;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.database.connector.SQLDatabaseConnector;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.database.AuthenticDatabaseProvider;
import xyz.kyngs.librelogin.common.database.AuthenticUser;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public abstract class LibreLoginSQLDatabaseProvider
extends AuthenticDatabaseProvider<SQLDatabaseConnector> {
    public LibreLoginSQLDatabaseProvider(SQLDatabaseConnector connector, AuthenticLibreLogin<?, ?> plugin) {
        super(connector, plugin);
    }

    @Override
    public Collection<User> getByIP(String ip) {
        this.plugin.reportMainThread();
        return ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            User user;
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM librepremium_data WHERE ip=?");
            ps.setString(1, ip);
            ResultSet rs = ps.executeQuery();
            ArrayList<User> users = new ArrayList<User>();
            while ((user = this.getUserFromResult(rs)) != null) {
                users.add(user);
            }
            return users;
        });
    }

    @Override
    public User getByName(String name) {
        this.plugin.reportMainThread();
        return ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM librepremium_data WHERE LOWER(last_nickname)=LOWER(?)");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            return this.getUserFromResult(rs);
        });
    }

    @Override
    public Collection<User> getAllUsers() {
        this.plugin.reportMainThread();
        return ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            User user;
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM librepremium_data");
            ResultSet rs = ps.executeQuery();
            ArrayList<User> users = new ArrayList<User>();
            while ((user = this.getUserFromResult(rs)) != null) {
                users.add(user);
            }
            return users;
        });
    }

    @Override
    public User getByUUID(UUID uuid) {
        this.plugin.reportMainThread();
        return ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM librepremium_data WHERE uuid=?");
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            return this.getUserFromResult(rs);
        });
    }

    @Override
    public User getByPremiumUUID(UUID uuid) {
        this.plugin.reportMainThread();
        return ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM librepremium_data WHERE premium_uuid=?");
            ps.setString(1, uuid.toString());
            ResultSet rs = ps.executeQuery();
            return this.getUserFromResult(rs);
        });
    }

    @Nullable
    private User getUserFromResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            UUID id = UUID.fromString(rs.getString("uuid"));
            String premiumUUID = rs.getString("premium_uuid");
            String hashedPassword = rs.getString("hashed_password");
            String salt = rs.getString("salt");
            String algo = rs.getString("algo");
            String lastNickname = rs.getString("last_nickname");
            Timestamp joinDate = rs.getTimestamp("joined");
            Timestamp lastSeen = rs.getTimestamp("last_seen");
            return new AuthenticUser(id, premiumUUID == null ? null : UUID.fromString(premiumUUID), hashedPassword == null ? null : new HashedPassword(hashedPassword, salt, algo), lastNickname, joinDate, lastSeen, rs.getString("secret"), rs.getString("ip"), rs.getTimestamp("last_authentication"), rs.getString("last_server"), rs.getString("email"));
        }
        return null;
    }

    @Override
    public void insertUser(User user) {
        this.plugin.reportMainThread();
        ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO librepremium_data(uuid, premium_uuid, hashed_password, salt, algo, last_nickname, joined, last_seen, secret, ip, last_authentication, last_server, email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.insertToStatement(ps, user);
            ps.executeUpdate();
        });
    }

    @Override
    public void insertUsers(Collection<User> users) {
        this.plugin.reportMainThread();
        ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT " + this.getIgnoreSyntax() + " INTO librepremium_data(uuid, premium_uuid, hashed_password, salt, algo, last_nickname, joined, last_seen, secret, ip, last_authentication, last_server, email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)" + this.getIgnoreSuffix());
            for (User user : users) {
                this.insertToStatement(ps, user);
                ps.addBatch();
            }
            ps.executeBatch();
        });
    }

    private void insertToStatement(PreparedStatement ps, User user) throws SQLException {
        ps.setString(1, user.getUuid().toString());
        ps.setString(2, user.getPremiumUUID() == null ? null : user.getPremiumUUID().toString());
        ps.setString(3, user.getHashedPassword() == null ? null : user.getHashedPassword().hash());
        ps.setString(4, user.getHashedPassword() == null ? null : user.getHashedPassword().salt());
        ps.setString(5, user.getHashedPassword() == null ? null : user.getHashedPassword().algo());
        ps.setString(6, user.getLastNickname());
        ps.setTimestamp(7, user.getJoinDate());
        ps.setTimestamp(8, user.getLastSeen());
        ps.setString(9, user.getSecret());
        ps.setString(10, user.getIp());
        ps.setTimestamp(11, user.getLastAuthentication());
        ps.setString(12, user.getLastServer());
        ps.setString(13, user.getEmail());
    }

    @Override
    public void updateUser(User user) {
        this.plugin.reportMainThread();
        ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("UPDATE librepremium_data SET premium_uuid=?, hashed_password=?, salt=?, algo=?, last_nickname=?, joined=?, last_seen=?, secret=?, ip=?, last_authentication=?, last_server=?, email=? WHERE uuid=?");
            ps.setString(1, user.getPremiumUUID() == null ? null : user.getPremiumUUID().toString());
            ps.setString(2, user.getHashedPassword() == null ? null : user.getHashedPassword().hash());
            ps.setString(3, user.getHashedPassword() == null ? null : user.getHashedPassword().salt());
            ps.setString(4, user.getHashedPassword() == null ? null : user.getHashedPassword().algo());
            ps.setString(5, user.getLastNickname());
            ps.setTimestamp(6, user.getJoinDate());
            ps.setTimestamp(7, user.getLastSeen());
            ps.setString(8, user.getSecret());
            ps.setString(9, user.getIp());
            ps.setTimestamp(10, user.getLastAuthentication());
            ps.setString(11, user.getLastServer());
            ps.setString(12, user.getEmail());
            ps.setString(13, user.getUuid().toString());
            ps.executeUpdate();
        });
    }

    @Override
    public void deleteUser(User user) {
        this.plugin.reportMainThread();
        ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            PreparedStatement ps = connection.prepareStatement("DELETE FROM librepremium_data WHERE uuid=?");
            ps.setString(1, user.getUuid().toString());
            ps.executeUpdate();
        });
    }

    @Override
    public void validateSchema() {
        ((SQLDatabaseConnector)this.connector).runQuery(connection -> {
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS librepremium_data(uuid VARCHAR(255) NOT NULL PRIMARY KEY,premium_uuid VARCHAR(255) UNIQUE,hashed_password VARCHAR(255),salt VARCHAR(255),algo VARCHAR(255),last_nickname VARCHAR(255) NOT NULL UNIQUE,joined TIMESTAMP NULL DEFAULT NULL,last_seen TIMESTAMP NULL DEFAULT NULL,last_server VARCHAR(255))").executeUpdate();
            List<String> columns = this.getColumnNames((Connection)connection);
            try {
                connection.prepareStatement(this.addUnique("premium_uuid")).executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!columns.contains("secret")) {
                connection.prepareStatement("ALTER TABLE librepremium_data ADD COLUMN secret VARCHAR(255) NULL DEFAULT NULL").executeUpdate();
            }
            if (!columns.contains("ip")) {
                connection.prepareStatement("ALTER TABLE librepremium_data ADD COLUMN ip VARCHAR(255) NULL DEFAULT NULL").executeUpdate();
            }
            if (!columns.contains("last_authentication")) {
                connection.prepareStatement("ALTER TABLE librepremium_data ADD COLUMN last_authentication TIMESTAMP NULL DEFAULT NULL").executeUpdate();
            }
            if (!columns.contains("last_server")) {
                connection.prepareStatement("ALTER TABLE librepremium_data ADD COLUMN last_server VARCHAR(255) NULL DEFAULT NULL").executeUpdate();
            }
            if (!columns.contains("email")) {
                connection.prepareStatement("ALTER TABLE librepremium_data ADD COLUMN email VARCHAR(255) NULL DEFAULT NULL").executeUpdate();
            }
            try {
                connection.prepareStatement(this.addUnique("last_nickname")).executeUpdate();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    protected abstract List<String> getColumnNames(Connection var1) throws SQLException;

    protected String getIgnoreSyntax() {
        return "";
    }

    protected String getIgnoreSuffix() {
        return "";
    }

    protected abstract String addUnique(String var1);
}

