/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.database.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import xyz.kyngs.librelogin.api.database.connector.SQLiteDatabaseConnector;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;
import xyz.kyngs.librelogin.common.database.connector.AuthenticDatabaseConnector;
import xyz.kyngs.librelogin.lib.hikari.HikariConfig;
import xyz.kyngs.librelogin.lib.hikari.HikariDataSource;

public class AuthenticSQLiteDatabaseConnector
extends AuthenticDatabaseConnector<SQLException, Connection>
implements SQLiteDatabaseConnector {
    private final HikariConfig hikariConfig = new HikariConfig();
    private HikariDataSource dataSource;

    public AuthenticSQLiteDatabaseConnector(AuthenticLibreLogin<?, ?> plugin, String prefix) {
        super(plugin, prefix);
        this.hikariConfig.setPoolName("LibreLogin SQLite Pool");
        this.hikariConfig.setDriverClassName("org.sqlite.JDBC");
        this.hikariConfig.setMaxLifetime(60000L);
        this.hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        this.hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.hikariConfig.setJdbcUrl("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/" + this.get(Configuration.PATH));
    }

    @Override
    public void connect() throws SQLException {
        this.dataSource = new HikariDataSource(this.hikariConfig);
        this.obtainInterface().close();
        this.connected = true;
    }

    @Override
    public void disconnect() throws SQLException {
        this.connected = false;
        this.dataSource.close();
    }

    @Override
    public Connection obtainInterface() throws SQLException, IllegalStateException {
        if (!this.connected()) {
            throw new IllegalStateException("Not connected to the database!");
        }
        return this.dataSource.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V runQuery(ThrowableFunction<Connection, V, SQLException> function) throws IllegalStateException {
        try (Connection connection = this.obtainInterface();){
            V v = function.apply(connection);
            return v;
        }
        catch (SQLTransientConnectionException e) {
            this.plugin.getLogger().error("!! LOST CONNECTION TO THE DATABASE, THE PROXY IS GOING TO SHUT DOWN TO PREVENT DAMAGE !!");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Configuration {
        public static final ConfigurationKey<String> PATH = new ConfigurationKey<String>("path", "user-data.db", "Path to SQLite database file. Relative to plugin datafolder.", ConfigurateHelper::getString);
    }
}

