/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.crypto;

import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.common.util.CryptoUtil;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;

public class Argon2IDCryptoProvider
implements CryptoProvider {
    private final Logger logger;
    private SecureRandom random;

    public Argon2IDCryptoProvider(Logger logger) {
        this.logger = logger;
        this.random = new SecureRandom();
    }

    @Override
    @Nullable
    public HashedPassword createHash(String password) {
        long start = System.currentTimeMillis();
        byte[] salt = new byte[16];
        this.random.nextBytes(salt);
        byte[] hash = new byte[32];
        Argon2Parameters params = new Argon2Parameters.Builder(2).withSalt(salt).withMemoryAsKB(16384).withIterations(2).build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params);
        generator.generateBytes(password.toCharArray(), hash);
        this.logger.debug("Argon2ID hash took " + (System.currentTimeMillis() - start) + "ms");
        return CryptoUtil.convertFromArgon2ID(hash, params);
    }

    @Override
    public boolean matches(String input, HashedPassword password) {
        CryptoUtil.Argon2IDHashedPassword params = CryptoUtil.rawArgonFromHashed(password);
        byte[] hashBytes = new byte[params.hash().length];
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params.parameters());
        generator.generateBytes(input.toCharArray(), hashBytes);
        return Arrays.equals(hashBytes, params.hash());
    }

    @Override
    public String getIdentifier() {
        return "Argon-2ID";
    }
}

