/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.LibreLoginPlugin;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.common.config.ConfigurateConfiguration;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.NewUUIDCreator;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;
import xyz.kyngs.librelogin.common.config.migrate.config.EightConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.FifthConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.FirstConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.FourthConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.SecondConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.SeventhConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.SixthConfigurationMigrator;
import xyz.kyngs.librelogin.common.config.migrate.config.ThirdConfigurationMigrator;

public class HoconPluginConfiguration {
    private final Logger logger;
    private final Collection<BiHolder<Class<?>, String>> defaultKeys;
    private ConfigurateHelper helper;

    public HoconPluginConfiguration(Logger logger, Collection<BiHolder<Class<?>, String>> defaultKeys) {
        this.logger = logger;
        this.defaultKeys = new ArrayList(defaultKeys);
        this.defaultKeys.add(new BiHolder<Class<ConfigurationKeys>, String>(ConfigurationKeys.class, ""));
    }

    public ConfigurateHelper getHelper() {
        return this.helper;
    }

    public boolean reload(LibreLoginPlugin<?, ?> plugin) throws IOException, CorruptedConfigurationException {
        ConfigurateConfiguration adept = new ConfigurateConfiguration(plugin.getDataFolder(), "config.conf", this.defaultKeys, "  !!THIS FILE IS WRITTEN IN THE HOCON FORMAT!!\n  The hocon format is very similar to JSON, but it has some extra features.\n  You can find more information about the format on the sponge wiki:\n  https://docs.spongepowered.org/stable/en/server/getting-started/configuration/hocon.html\n  ----------------------------------------------------------------------------------------\n  LibreLogin Configuration\n  ----------------------------------------------------------------------------------------\n  This is the configuration file for LibreLogin.\n  You can find more information about LibreLogin on the github page:\n  https://github.com/kyngs/LibreLogin\n", this.logger, new FirstConfigurationMigrator(), new SecondConfigurationMigrator(), new ThirdConfigurationMigrator(), new FourthConfigurationMigrator(), new FifthConfigurationMigrator(), new SixthConfigurationMigrator(), new SeventhConfigurationMigrator(), new EightConfigurationMigrator());
        ConfigurateHelper helperAdept = adept.getHelper();
        if (!adept.isNewlyCreated() && plugin.getCryptoProvider(helperAdept.get(ConfigurationKeys.DEFAULT_CRYPTO_PROVIDER)) == null) {
            throw new CorruptedConfigurationException("Crypto provider not found");
        }
        this.helper = helperAdept;
        return adept.isNewlyCreated();
    }

    public NewUUIDCreator getNewUUIDCreator() {
        String name = this.get(ConfigurationKeys.NEW_UUID_CREATOR);
        try {
            return NewUUIDCreator.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return NewUUIDCreator.RANDOM;
        }
    }

    public <T> T get(ConfigurationKey<T> key) {
        return this.helper.get(key);
    }
}

