/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import xyz.kyngs.librelogin.common.authorization.ProfileConflictResolutionStrategy;
import xyz.kyngs.librelogin.common.config.ConfigurateHelper;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;

public class ConfigurationKeys {
    public static final ConfigurationKey<List<String>> ALLOWED_COMMANDS_WHILE_UNAUTHORIZED = new ConfigurationKey<List>("allowed-commands-while-unauthorized", List.of("login", "register", "2fa", "2faconfirm", "l", "log", "reg", "resetpassword", "confirmpasswordreset"), "Commands that are allowed while the user is not authorized.", ConfigurateHelper::getStringList);
    public static final ConfigurationKey<List<String>> LIMBO = new ConfigurationKey<List>("limbo", List.of("limbo0", "limbo1"), "The authentication servers/worlds, players should be sent to, when not authenticated. On Paper, players will be spawned on the world spawn. THIS SERVERS MUST BE REGISTERED IN THE PROXY CONFIG. IN CASE OF PAPER, THE WORLDS MUST EXIST.", ConfigurateHelper::getStringList);
    public static final Multimap<String, String> LOBBY_DEFAULT = HashMultimap.create();
    public static final ConfigurationKey<Multimap<String, String>> LOBBY = new ConfigurationKey<Multimap>("lobby", LOBBY_DEFAULT, "!!WHEN USING PAPER, PUT ALL WORLDS UNDER \"root\"!!\nOn Paper, players will be spawned on the world spawn.\n\nThe servers/worlds player should be sent to when they are authenticated. THE SERVERS MUST BE REGISTERED IN THE PROXY CONFIG. IN CASE OF PAPER, THE WORLDS MUST EXIST.\nThe configuration allows configuring forced hosts; the servers/worlds in \"root\" are used when players do not connect from a forced host. Use \u00a7 instead of dots.\nSee: https://github.com/kyngs/LibrePremium/wiki/Configuring-Servers\n", ConfigurateHelper::getServerMap);
    public static final ConfigurationKey<Boolean> IGNORE_MAX_PLAYERS_FROM_BACKEND_PING;
    public static final ConfigurationKey<String> DEFAULT_CRYPTO_PROVIDER;
    public static final ConfigurationKey<String> PROFILE_CONFLICT_RESOLUTION_STRATEGY;
    public static final ConfigurationKey<Integer> MAX_LOGIN_ATTEMPTS;
    public static final ConfigurationKey<Integer> MILLISECONDS_TO_EXPIRE_LOGIN_ATTEMPTS;
    public static final ConfigurationKey<Boolean> USE_TITLES;
    public static final ConfigurationKey<Boolean> USE_ACTION_BAR;
    public static final ConfigurationKey<String> NEW_UUID_CREATOR;
    public static final ConfigurationKey<Integer> IP_LIMIT;
    public static final ConfigurationKey<Boolean> AUTO_REGISTER;
    public static final ConfigurationKey<Integer> MILLISECONDS_TO_REFRESH_NOTIFICATION;
    public static final ConfigurationKey<Integer> SECONDS_TO_AUTHORIZE;
    public static final ConfigurationKey<?> DATABASE;
    public static final ConfigurationKey<String> DATABASE_TYPE;
    public static final ConfigurationKey<?> MIGRATION;
    public static final ConfigurationKey<Boolean> MIGRATION_ON_NEXT_STARTUP;
    public static final ConfigurationKey<String> MIGRATION_TYPE;
    public static final ConfigurationKey<String> MIGRATION_MYSQL_OLD_DATABASE_TABLE;
    public static final ConfigurationKey<String> MIGRATION_POSTGRESQL_OLD_DATABASE_TABLE;
    public static final ConfigurationKey<?> TOTP;
    public static final ConfigurationKey<Boolean> TOTP_ENABLED;
    public static final ConfigurationKey<String> TOTP_LABEL;
    public static final ConfigurationKey<Integer> MINIMUM_PASSWORD_LENGTH;
    public static final ConfigurationKey<Integer> MINIMUM_USERNAME_LENGTH;
    public static final ConfigurationKey<Long> SESSION_TIMEOUT;
    public static final ConfigurationKey<Boolean> PING_SERVERS;
    public static final ConfigurationKey<Boolean> REMEMBER_LAST_SERVER;
    public static final ConfigurationKey<Boolean> DEBUG;
    public static final ConfigurationKey<Boolean> FALLBACK;
    public static final ConfigurationKey<Integer> TOTP_DELAY;
    public static final ConfigurationKey<Boolean> MAIL_ENABLED;
    public static final ConfigurationKey<String> MAIL_HOST;
    public static final ConfigurationKey<Integer> MAIL_PORT;
    public static final ConfigurationKey<String> MAIL_USERNAME;
    public static final ConfigurationKey<String> MAIL_PASSWORD;
    public static final ConfigurationKey<String> MAIL_SENDER;
    public static final ConfigurationKey<String> MAIL_EMAIL;
    private static final ConfigurationKey<?> MAIL;
    public static final ConfigurationKey<Boolean> ALLOW_PROXY_CONNECTIONS;
    public static final ConfigurationKey<String> LIMBO_PORT_RANGE;

    static {
        LOBBY_DEFAULT.put((Object)"root", (Object)"lobby0");
        LOBBY_DEFAULT.put((Object)"root", (Object)"lobby1");
        IGNORE_MAX_PLAYERS_FROM_BACKEND_PING = new ConfigurationKey<Boolean>("ignore-max-players-from-backend-ping", false, "By default, when choosing available lobby/limbos LibreLogin will rule out all the servers which are full.\nSometimes this may not work as expected. In such case, you can enable this option, which will ignore the max players field obtained by pinging the backend server.\n", ConfigurateHelper::getBoolean);
        DEFAULT_CRYPTO_PROVIDER = new ConfigurationKey<String>("default-crypto-provider", "BCrypt-2A", "The default crypto provider. This is used for hashing passwords. Available Providers:\nSHA-256 - Older, not recommended. Kept for compatibility reasons.\nSHA-512 - More safer than SHA-256, but still not recommended. Kept for compatibility reasons.\nBCrypt-2A - Newer, more safe, recommended\nArgon-2ID - Newest, should be safer than BCrypt-2A, however, it can slow down the server.\n", ConfigurateHelper::getString);
        PROFILE_CONFLICT_RESOLUTION_STRATEGY = new ConfigurationKey<String>("profile-conflict-resolution-strategy", "BLOCK", "Sets the strategy for resolving profile conflicts. Available strategies:\nBLOCK - Kick both players with the message key \"kick-name-mismatch\". An admin must resolve the conflict manually.\nUSE_OFFLINE - Use the offline profile. When both of the players attempt to join, they will be provided with a login screen and will be able to login with the offline player's password. The online player will have to change their nickname to a available one in order to recover their account. Beware, that there's a 30 days cool down for changing nicknames.\nOVERWRITE - Overwrite the offline profile's data with the online profile's data. This will irreversibly delete the offline player's data. !!USE WITH CAUTION; PLAYERS CAN AND WILL ABUSE THIS!!\n", (helper, key) -> ProfileConflictResolutionStrategy.valueOf(helper.getString((String)key).toUpperCase()).name());
        MAX_LOGIN_ATTEMPTS = new ConfigurationKey<Integer>("max-login-attempts", -1, "Kick the player, if the password was incorrect more or equal times. -1 means disabled", ConfigurateHelper::getInt);
        MILLISECONDS_TO_EXPIRE_LOGIN_ATTEMPTS = new ConfigurationKey<Integer>("milliseconds-to-refresh-login-attempts", 10000, "Time to reset login attempts. The amount of time the player should have waited for their login attempts to expire. On every rejoin, login attempts are reset.", ConfigurateHelper::getInt);
        USE_TITLES = new ConfigurationKey<Boolean>("use-titles", true, "Whether or not to use titles when player is awaiting authentication.", ConfigurateHelper::getBoolean);
        USE_ACTION_BAR = new ConfigurationKey<Boolean>("use-action-bar", false, "Whether or not to use action bar when player is awaiting authentication.", ConfigurateHelper::getBoolean);
        NEW_UUID_CREATOR = new ConfigurationKey<String>("new-uuid-creator", "CRACKED", "Sets which method should be used for creating fixed UUID when a new player is created.\nSee the wiki for further information: https://github.com/kyngs/LibreLogin/wiki/UUID-Creators\nAvailable Creators:\nRANDOM - Generates a random UUID\nCRACKED - Generates a UUID based on the player's name, the same method as if the server was in offline mode\nMOJANG - If the player exists in the Mojang's database, it will be used. Otherwise, CRACKED will be used.\n", ConfigurateHelper::getString);
        IP_LIMIT = new ConfigurationKey<Integer>("ip-limit", -1, "Sets the maximum amount of accounts that can be registered from the same IP address.\nSet to zero or less to disable.\n!!THIS IS NOT RECOMMENDED!! Due to the lack of IPv4 addresses, sometimes even entire villages share the same IP address.\n", ConfigurateHelper::getInt);
        AUTO_REGISTER = new ConfigurationKey<Boolean>("auto-register", false, "Should we automatically register all players with a premium nickname?\n!!CRACKED PLAYERS WILL NOT BE ABLE TO REGISTER PREMIUM USERNAMES!!\n", ConfigurateHelper::getBoolean);
        MILLISECONDS_TO_REFRESH_NOTIFICATION = new ConfigurationKey<Integer>("milliseconds-to-refresh-notification", 10000, "This specifies how often players should be notified when not authenticated. Set to negative to disable.\nThis includes (but is not limited to):\n- Message in chat\n- Title\n", ConfigurateHelper::getInt);
        SECONDS_TO_AUTHORIZE = new ConfigurationKey<Integer>("seconds-to-authorize", -1, "Sets the login/register time limit in seconds. Set to negative to disable.", ConfigurateHelper::getInt);
        DATABASE = ConfigurationKey.getComment("database", "This section is used for MySQL database configuration.");
        DATABASE_TYPE = new ConfigurationKey<String>("database.type", "librelogin-sqlite", "The type of the database. Built-in types:\nlibrelogin-mysql - MySQL database, you must fill out the mysql section below.\nlibrelogin-postgresql - PostgreSQL database, you must fill out the postgresql section below.\nlibrelogin-sqlite - SQLite database, default file is \"database.db\", you can change it in the sqlite section below.\n", ConfigurateHelper::getString);
        MIGRATION = ConfigurationKey.getComment("migration", "This is used for migrating the database from other plugins.\nPlease see the wiki for further information: https://github.com/kyngs/LibreLogin/wiki/Database-Migration\n");
        MIGRATION_ON_NEXT_STARTUP = new ConfigurationKey<Boolean>("migration.on-next-startup", false, "Migrate the database on the next startup.", ConfigurateHelper::getBoolean);
        MIGRATION_TYPE = new ConfigurationKey<String>("migration.type", "authme-sqlite", "The type of the migration. Available Types:\njpremium-mysql - Can convert from MySQL JPremium SHA256, SHA512 and BCrypt\nauthme-mysql - Can convert from MySQL AuthMe BCrypt and SHA256\nauthme-sqlite - Can convert from SQLite AuthMe BCrypt and SHA256\nauthme-postgresql - Can convert from PostgreSQL AuthMe BCrypt and SHA256\naegis-mysql - Can convert from MySQL Aegis BCrypt\ndba-mysql - Can convert from MySQL DynamicBungeeAuth, which was configured to use SHA-512\nnlogin-sqlite - Can convert from SQLite NLogin SHA512\nnlogin-mysql - Can convert from MySQL NLogin SHA512\nloginsecurity-mysql - Can convert from MySQL LoginSecurity BCrypt\nloginsecurity-sqlite - Can convert from SQLite LoginSecurity BCrypt\nfastlogin-sqlite - Can convert from SQLite FastLogin, !!YOU MUST RUN CONVERSION FROM AUTHME FIRST!!\nfastlogin-mysql - Can convert from MySQL FastLogin, !!YOU MUST RUN CONVERSION FROM AUTHME FIRST!!\nlimboauth-mysql - Can convert from MySQL LimboAuth BCrypt and SHA256\nauthy-mysql - Can convert from MySQL Authy SHA256\nauthy-sqlite - Can convert from SQLite Authy SHA256\nlogit-mysql - Can convert from MySQL LogIt SHA256\nlibrelogin-mysql - Can convert from MySQL LibreLogin, useful for migrating to a different database\nlibrelogin-sqlite - Can convert from SQLite LibreLogin, useful for migrating to a different database\n", ConfigurateHelper::getString);
        MIGRATION_MYSQL_OLD_DATABASE_TABLE = new ConfigurationKey<String>("migration.old-database.mysql.table", "user-data", "The table of the old database.", ConfigurateHelper::getString);
        MIGRATION_POSTGRESQL_OLD_DATABASE_TABLE = new ConfigurationKey<String>("migration.old-database.postgresql.table", "user-data", "The table of the old database.", ConfigurateHelper::getString);
        TOTP = ConfigurationKey.getComment("totp", "This section is used for 2FA configuration.\n!! YOU MUST HAVE PROTOCOLIZE INSTALLED FOR THIS TO WORK !!\n\nYou can find more information on the wiki: https://github.com/kyngs/LibreLogin/wiki/2FA\n");
        TOTP_ENABLED = new ConfigurationKey<Boolean>("totp.enabled", true, "Should we enable TOTP-Based Two-Factor Authentication? If you don't know what this is, this is the 2FA used in applications like Google Authenticator etc.\nI heavily suggest you to read this wiki page: https://github.com/kyngs/LibreLogin/wiki/2FA\n", ConfigurateHelper::getBoolean);
        TOTP_LABEL = new ConfigurationKey<String>("totp.label", "LibreLogin Network", "The label to be displayed in the 2FA app. Change this to your network name.", ConfigurateHelper::getString);
        MINIMUM_PASSWORD_LENGTH = new ConfigurationKey<Integer>("minimum-password-length", -1, "The minimum length of a password. Set to negative to disable.", ConfigurateHelper::getInt);
        MINIMUM_USERNAME_LENGTH = new ConfigurationKey<Integer>("minimum-username-length", -1, "The minimum length the player's name can have. Only applies to new players, set to 0 or lower to disable.", ConfigurateHelper::getInt);
        SESSION_TIMEOUT = new ConfigurationKey<Long>("session-timeout", 0L, "Defines a time in seconds after a player's session expires. Default value is one week (604800 seconds). Set to zero or less to disable sessions.", ConfigurateHelper::getLong);
        PING_SERVERS = new ConfigurationKey<Boolean>("ping-servers", false, "!!THIS OPTION IS IRRELEVANT WHEN USING PAPER!! Should we ping servers to check if they are online, and get their player count? If you disable this, the pinging servers message will still appear in the console, even though the servers will not be pinged.", ConfigurateHelper::getBoolean);
        REMEMBER_LAST_SERVER = new ConfigurationKey<Boolean>("remember-last-server", false, "Should we remember the last server/world a player was on? This is not recommended for large networks.", ConfigurateHelper::getBoolean);
        DEBUG = new ConfigurationKey<Boolean>("debug", false, "Should we enable debug mode? This will print out debug messages to the console.", ConfigurateHelper::getBoolean);
        FALLBACK = new ConfigurationKey<Boolean>("fallback", false, "!!THIS OPTION IS IRRELEVANT WHEN USING PAPER!! Should we fallback players to lobby servers if the server they are on shutdowns? If set to false, they will be kicked.", ConfigurateHelper::getBoolean);
        TOTP_DELAY = new ConfigurationKey<Integer>("totp.delay", 1000, "The delay in milliseconds until player is given a map to scan the QR code. Increase this value if the map disappears too quickly.", ConfigurateHelper::getInt);
        MAIL_ENABLED = new ConfigurationKey<Boolean>("mail.enabled", false, "Should we enable the email password recovery feature?", ConfigurateHelper::getBoolean);
        MAIL_HOST = new ConfigurationKey<String>("mail.host", "smtp.gmail.com", "The host of the SMTP server.", ConfigurateHelper::getString);
        MAIL_PORT = new ConfigurationKey<Integer>("mail.port", 587, "The port of the SMTP server.", ConfigurateHelper::getInt);
        MAIL_USERNAME = new ConfigurationKey<String>("mail.username", "username", "The username used to login to the SMTP server.", ConfigurateHelper::getString);
        MAIL_PASSWORD = new ConfigurationKey<String>("mail.password", "password", "The password used to login to the SMTP server. We highly recommend you use a unique one-time password for this.", ConfigurateHelper::getString);
        MAIL_SENDER = new ConfigurationKey<String>("mail.sender", "LibreLogin Network", "The sender of the email.", ConfigurateHelper::getString);
        MAIL_EMAIL = new ConfigurationKey<String>("mail.email", "email@something.com", "The email to use as a sender in the From field.", ConfigurateHelper::getString);
        MAIL = ConfigurationKey.getComment("mail", "This section is used for configuring the email password recovery feature.\n");
        ALLOW_PROXY_CONNECTIONS = new ConfigurationKey<Boolean>("allow-proxy-connections", true, "!!!THIS ONLY AFFECTS PAPER!!!\nVerifies whether the IP the players had used when authenticating to Mojang matches the IP they are connecting from. Disabling this may break LibreLogin if the server is running under a reverse proxy/VPN.\n", ConfigurateHelper::getBoolean);
        LIMBO_PORT_RANGE = new ConfigurationKey<String>("limbo-port-range", "30000-40000", "!!THIS OPTION IS IRRELEVANT WHEN USING PAPER!! Defines port(s) that limbo server can be bounded to.", ConfigurateHelper::getString);
    }
}

