/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.config;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import xyz.kyngs.librelogin.api.configuration.CorruptedConfigurationException;
import xyz.kyngs.librelogin.api.util.ThrowableFunction;
import xyz.kyngs.librelogin.common.config.key.ConfigurationKey;
import xyz.kyngs.librelogin.lib.configurate.CommentedConfigurationNode;
import xyz.kyngs.librelogin.lib.configurate.serialize.SerializationException;

public record ConfigurateHelper(CommentedConfigurationNode configuration) {
    public String getString(String path) {
        return this.get(String.class, path);
    }

    public Integer getInt(String path) {
        return this.get(Integer.class, path);
    }

    public Boolean getBoolean(String path) {
        return this.get(Boolean.class, path);
    }

    public Long getLong(String path) {
        return this.get(Long.class, path);
    }

    public <T> T get(Class<T> clazz, String path) {
        return (T)this.configurationFunction(path, node -> {
            if (node.isList()) {
                throw new CorruptedConfigurationException("Node is a list!");
            }
            return node.get(clazz);
        });
    }

    public List<String> getStringList(String path) {
        return this.getList(String.class, path);
    }

    public <T> List<T> getList(Class<T> clazz, String path) {
        return this.configurationFunction(path, node -> {
            if (!node.isList()) {
                throw new CorruptedConfigurationException("Node is not a list!");
            }
            return node.getList(clazz);
        });
    }

    public Multimap<String, String> getServerMap(String path) {
        return (Multimap)this.configurationFunction(path, node -> {
            if (!node.isMap()) {
                throw new CorruptedConfigurationException("Node is not a map!");
            }
            HashMultimap map = HashMultimap.create();
            for (Map.Entry entry : node.childrenMap().entrySet()) {
                if (!((CommentedConfigurationNode)entry.getValue()).isList()) {
                    throw new CorruptedConfigurationException("Node is not a list!");
                }
                List list = ((CommentedConfigurationNode)entry.getValue()).getList(String.class);
                if (list == null) {
                    throw new CorruptedConfigurationException("List is null!");
                }
                for (String s : list) {
                    map.put((Object)entry.getKey().toString().replace('\u00a7', '.'), (Object)s);
                }
            }
            return map;
        });
    }

    public void set(String path, Object value) {
        try {
            CommentedConfigurationNode node = this.resolve(path);
            if (value instanceof Multimap) {
                Multimap multimap = (Multimap)value;
                for (Map.Entry entry : multimap.asMap().entrySet()) {
                    ((CommentedConfigurationNode)node.node(new Object[]{entry.getKey().toString()})).set(entry.getValue());
                }
            } else {
                node.set(value);
            }
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public CommentedConfigurationNode resolve(String key) {
        return (CommentedConfigurationNode)this.configuration.node(Splitter.on((char)'.').splitToList((CharSequence)key).toArray());
    }

    public <T> T configurationFunction(String path, ThrowableFunction<CommentedConfigurationNode, T, Exception> function) {
        try {
            CommentedConfigurationNode node = this.resolve(path);
            if (node == null || node.virtual()) {
                return null;
            }
            return function.apply(this.resolve(path));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDefault(ConfigurationKey<?> key, String prefix) {
        Object defaultValue = key.defaultValue();
        if (defaultValue != null) {
            this.set(prefix + key.key(), defaultValue);
        }
    }

    public void setComment(ConfigurationKey<?> key, String prefix) {
        this.resolve(prefix + key.key()).comment(key.comment());
    }

    public <T> T get(ConfigurationKey<T> key) {
        return key.compute(this);
    }
}

