/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.staff;

import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.Command;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.NotNull;

public class StaffCommand<P>
extends Command<P> {
    public StaffCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @NotNull
    protected User getUserOtherWiseInform(String name) {
        User user = this.plugin.getDatabaseProvider().getByName(name);
        if (user == null) {
            throw new InvalidCommandArgument(this.getMessage("error-unknown-user", new String[0]));
        }
        return user;
    }

    protected void requireOffline(User user) {
        if (this.plugin.isPresent(user.getUuid())) {
            throw new InvalidCommandArgument(this.getMessage("error-player-online", new String[0]));
        }
    }

    protected P requireOnline(User user) {
        if (this.plugin.multiProxyEnabled()) {
            throw new InvalidCommandArgument(this.getMessage("error-not-available-on-multi-proxy", new String[0]));
        }
        Object player = this.plugin.getPlayerForUUID(user.getUuid());
        if (player == null) {
            throw new InvalidCommandArgument(this.getMessage("error-player-offline", new String[0]));
        }
        return player;
    }

    protected P getPossiblyOnlinePlayerOnThisProxy(User user) {
        if (this.plugin.multiProxyEnabled()) {
            if (this.plugin.isPresent(user.getUuid())) {
                throw new InvalidCommandArgument(this.getMessage("error-player-online", new String[0]));
            }
            return null;
        }
        return this.plugin.getPlayerForUUID(user.getUuid());
    }

    protected void requireUnAuthorized(P player) {
        if (((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).isAuthorized(player)) {
            throw new InvalidCommandArgument(this.getMessage("error-player-authorized", new String[0]));
        }
    }

    protected void requireRegistered(User user) {
        if (!user.isRegistered()) {
            throw new InvalidCommandArgument(this.getMessage("error-player-not-registered", new String[0]));
        }
    }
}

