/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.premium;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Syntax;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.WrongPasswordEvent;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.premium.PremiumCommand;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticWrongPasswordEvent;

@CommandAlias(value="premium|autologin")
public class PremiumEnableCommand<P>
extends PremiumCommand<P> {
    public PremiumEnableCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.premium}")
    @CommandCompletion(value="%autocomplete.premium")
    public CompletionStage<Void> onPremium(Audience sender, UUID uuid, P player, @Single String password) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            this.checkCracked(user);
            HashedPassword hashed = user.getHashedPassword();
            CryptoProvider crypto = this.getCrypto(hashed);
            if (!crypto.matches(password, hashed)) {
                ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().wrongPassword, new AuthenticWrongPasswordEvent(user, player, this.plugin, WrongPasswordEvent.AuthenticationSource.PREMIUM_ENABLE));
                throw new InvalidCommandArgument(this.getMessage("error-password-wrong", new String[0]));
            }
            this.plugin.getCommandProvider().registerConfirm(uuid);
            sender.sendMessage((Component)this.getMessage("prompt-confirm", new String[0]));
        });
    }
}

