/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.mail;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Syntax;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.mail.EMailCommand;

@CommandAlias(value="verifyemail")
public class VerifyEMailCommand<P>
extends EMailCommand<P> {
    public VerifyEMailCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.verify-email}")
    @CommandCompletion(value="%autocomplete.verify-email")
    public CompletionStage<Void> onVerifyMail(P player, Audience sender, String token) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            AuthenticAuthorizationProvider.EmailVerifyData cached = (AuthenticAuthorizationProvider.EmailVerifyData)((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).getEmailConfirmCache().getIfPresent((Object)user.getUuid());
            if (cached == null) {
                throw new InvalidCommandArgument(this.getMessage("error-no-mail-confirm", new String[0]));
            }
            if (!cached.token().equals(token)) {
                throw new InvalidCommandArgument(this.getMessage("error-wrong-mail-verify", new String[0]));
            }
            ((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).getEmailConfirmCache().invalidate((Object)user.getUuid());
            user.setEmail(cached.email());
            this.getDatabaseProvider().updateUser(user);
            sender.sendMessage((Component)this.getMessage("info-mail-verified", new String[0]));
        });
    }
}

