/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands.mail;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Syntax;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.authorization.AuthenticAuthorizationProvider;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.command.commands.mail.EMailCommand;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticPasswordChangeEvent;

@CommandAlias(value="confirmpasswordreset")
public class ConfirmPasswordReset<P>
extends EMailCommand<P> {
    public ConfirmPasswordReset(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.confirm-password-reset}")
    @CommandCompletion(value="%autocomplete.confirm-password-reset")
    public CompletionStage<Void> onConfirmPassReset(Audience audience, P player, String token, String password, @Single String passwordRepeat) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            String cached = (String)((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).getPasswordResetCache().getIfPresent((Object)user.getUuid());
            if (cached == null) {
                throw new InvalidCommandArgument(this.getMessage("error-no-password-reset", new String[0]));
            }
            if (!cached.equals(token)) {
                throw new InvalidCommandArgument(this.getMessage("error-wrong-password-reset", new String[0]));
            }
            if (!password.equals(passwordRepeat)) {
                throw new InvalidCommandArgument(this.getMessage("error-password-not-match", new String[0]));
            }
            HashedPassword old = user.getHashedPassword();
            this.setPassword(audience, user, password, "info-resetting-password");
            ((AuthenticAuthorizationProvider)this.plugin.getAuthorizationProvider()).getPasswordResetCache().invalidate((Object)user.getUuid());
            this.getDatabaseProvider().updateUser(user);
            audience.sendMessage((Component)this.getMessage("info-password-reset", new String[0]));
            ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().passwordChange, new AuthenticPasswordChangeEvent(user, player, this.plugin, old));
        });
    }
}

