/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.common.command.commands;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Syntax;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import xyz.kyngs.librelogin.api.crypto.CryptoProvider;
import xyz.kyngs.librelogin.api.crypto.HashedPassword;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.events.WrongPasswordEvent;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.command.Command;
import xyz.kyngs.librelogin.common.command.InvalidCommandArgument;
import xyz.kyngs.librelogin.common.event.AuthenticEventProvider;
import xyz.kyngs.librelogin.common.event.events.AuthenticPasswordChangeEvent;
import xyz.kyngs.librelogin.common.event.events.AuthenticWrongPasswordEvent;

@CommandAlias(value="changepassword|changepass|passwd|passch")
public class ChangePasswordCommand<P>
extends Command<P> {
    public ChangePasswordCommand(AuthenticLibreLogin<P, ?> plugin) {
        super(plugin);
    }

    @Default
    @Syntax(value="{@@syntax.change-password}")
    @CommandCompletion(value="%autocomplete.change-password")
    public CompletionStage<Void> onPasswordChange(Audience sender, P player, String oldPass, @Single String newPass) {
        return this.runAsync(() -> {
            User user = this.getUser(player);
            if (!user.isRegistered()) {
                throw new InvalidCommandArgument(this.getMessage("error-no-password", new String[0]));
            }
            HashedPassword hashed = user.getHashedPassword();
            CryptoProvider crypto = this.getCrypto(hashed);
            if (!crypto.matches(oldPass, hashed)) {
                ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().wrongPassword, new AuthenticWrongPasswordEvent(user, player, this.plugin, WrongPasswordEvent.AuthenticationSource.CHANGE_PASSWORD));
                throw new InvalidCommandArgument(this.getMessage("error-password-wrong", new String[0]));
            }
            this.setPassword(sender, user, newPass, "info-editing");
            this.getDatabaseProvider().updateUser(user);
            sender.sendMessage((Component)this.getMessage("info-edited", new String[0]));
            ((AuthenticEventProvider)this.plugin.getEventProvider()).unsafeFire(this.plugin.getEventTypes().passwordChange, new AuthenticPasswordChangeEvent(user, player, this.plugin, hashed));
        });
    }
}

