/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.bungeecord;

import com.google.common.base.MoreObjects;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.server.ServerPing;
import xyz.kyngs.librelogin.bungeecord.BungeeCordLibreLogin;

public class BungeeCordPlatformHandle
implements PlatformHandle<ProxiedPlayer, ServerInfo> {
    private final BungeeCordLibreLogin plugin;

    public BungeeCordPlatformHandle(BungeeCordLibreLogin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Audience getAudienceForPlayer(ProxiedPlayer player) {
        return this.plugin.getAdventure().player(player);
    }

    @Override
    public UUID getUUIDForPlayer(ProxiedPlayer player) {
        return player.getUniqueId();
    }

    @Override
    public CompletableFuture<Throwable> movePlayer(ProxiedPlayer player, ServerInfo to) {
        return CompletableFuture.supplyAsync(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            Throwable[] ref = new Throwable[1];
            player.connect(to, (result, error) -> {
                ref[0] = result != false ? null : (error == null ? new RuntimeException("Failed to move player") : error);
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                return null;
            }
            return ref[0];
        });
    }

    @Override
    public void kick(ProxiedPlayer player, Component reason) {
        player.disconnect(this.plugin.getSerializer().serialize(reason));
    }

    @Override
    public ServerInfo getServer(String name, boolean limbo) {
        ServerInfo serverInfo = this.plugin.getBootstrap().getProxy().getServerInfo(name);
        if (serverInfo != null) {
            return serverInfo;
        }
        if (limbo && this.plugin.getLimboIntegration() != null) {
            return this.plugin.getLimboIntegration().createLimbo(name);
        }
        return null;
    }

    @Override
    public Class<ServerInfo> getServerClass() {
        return ServerInfo.class;
    }

    @Override
    public Class<ProxiedPlayer> getPlayerClass() {
        return ProxiedPlayer.class;
    }

    @Override
    public String getIP(ProxiedPlayer player) {
        return player.getAddress().getAddress().getHostAddress();
    }

    @Override
    public ServerPing ping(ServerInfo server) {
        CountDownLatch latch = new CountDownLatch(1);
        ServerPing[] ref = new ServerPing[1];
        server.ping((result, error) -> {
            ServerPing serverPing = error == null ? new ServerPing(result.getPlayers().getMax() == -1 ? Integer.MAX_VALUE : result.getPlayers().getMax()) : (ref[0] = null);
            if (error != null) {
                this.plugin.getLogger().debug("Failed to ping server: " + error.getMessage());
            }
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            return null;
        }
        return ref[0];
    }

    @Override
    public Collection<ServerInfo> getServers() {
        return this.plugin.getBootstrap().getProxy().getServers().values();
    }

    @Override
    public String getServerName(ServerInfo server) {
        return server.getName();
    }

    @Override
    public int getConnectedPlayers(ServerInfo server) {
        return server.getPlayers().size();
    }

    @Override
    public String getPlayersServerName(ProxiedPlayer player) {
        Server server = player.getServer();
        return server == null ? null : server.getInfo().getName();
    }

    @Override
    public String getPlayersVirtualHost(ProxiedPlayer player) {
        InetSocketAddress virt = player.getPendingConnection().getVirtualHost();
        return virt == null ? null : virt.getHostName();
    }

    @Override
    public String getUsernameForPlayer(ProxiedPlayer player) {
        return player.getName();
    }

    @Override
    public String getPlatformIdentifier() {
        return "bungeecord";
    }

    @Override
    public PlatformHandle.ProxyData getProxyData() {
        return new PlatformHandle.ProxyData(this.plugin.getBootstrap().getProxy().getName() + " " + this.plugin.getBootstrap().getProxy().getVersion(), this.getServers().stream().map(this::fromServer).toList(), this.plugin.getBootstrap().getProxy().getPluginManager().getPlugins().stream().map(plugin -> MoreObjects.toStringHelper((Object)plugin).add("name", (Object)plugin.getDescription().getName()).add("version", (Object)plugin.getDescription().getVersion()).add("author", (Object)plugin.getDescription().getAuthor()).add("main", (Object)plugin.getDescription().getMain()).toString()).toList(), this.plugin.getServerHandler().getLimboServers().stream().map(this::fromServer).toList(), this.plugin.getServerHandler().getLobbyServers().values().stream().map(this::fromServer).toList());
    }

    private String fromServer(ServerInfo server) {
        return MoreObjects.toStringHelper((Object)server).add("name", (Object)server.getName()).add("address", (Object)server.getAddress().getAddress().getHostAddress()).add("port", server.getAddress().getPort()).add("motd", (Object)server.getMotd()).add("restricted", server.isRestricted()).add("online", server.getPlayers().size()).add("max", server.getPlayers().size()).toString();
    }
}

