/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.bungeecord;

import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.AsyncEvent;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import xyz.kyngs.librelogin.api.BiHolder;
import xyz.kyngs.librelogin.api.Logger;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.bungeecord.BungeeCordLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.listener.AuthenticListeners;
import xyz.kyngs.librelogin.common.listener.PreLoginResult;
import xyz.kyngs.librelogin.common.util.GeneralUtil;

public class BungeeCordListener
extends AuthenticListeners<BungeeCordLibreLogin, ProxiedPlayer, ServerInfo>
implements Listener {
    public BungeeCordListener(BungeeCordLibreLogin plugin) {
        super(plugin);
    }

    public void runAsyncEvent(AsyncEvent<?> event, Runnable runnable) {
        event.registerIntent((Plugin)((BungeeCordLibreLogin)this.plugin).getBootstrap());
        GeneralUtil.ASYNC_POOL.execute(() -> {
            try {
                runnable.run();
            }
            finally {
                event.completeIntent((Plugin)((BungeeCordLibreLogin)this.plugin).getBootstrap());
            }
        });
    }

    @EventHandler(priority=64)
    public void onPostLogin(PostLoginEvent event) {
        this.runAsyncEvent((AsyncEvent<?>)event, () -> this.onPostLogin(event.getPlayer(), null));
    }

    @EventHandler
    public void onDisconnect(PlayerDisconnectEvent event) {
        this.onPlayerDisconnect(event.getPlayer());
    }

    @EventHandler(priority=64)
    public void onPreLogin(PreLoginEvent event) {
        if (((BungeeCordLibreLogin)this.plugin).fromFloodgate(event.getConnection().getUniqueId())) {
            return;
        }
        this.runAsyncEvent((AsyncEvent<?>)event, () -> {
            PreLoginResult result = this.onPreLogin(event.getConnection().getName(), event.getConnection().getAddress().getAddress());
            switch (result.state()) {
                case DENIED: {
                    assert (result.message() != null);
                    event.setCancelled(true);
                    event.setCancelReason(((BungeeCordLibreLogin)this.plugin).getSerializer().serialize(result.message()));
                    break;
                }
                case FORCE_ONLINE: {
                    event.getConnection().setOnlineMode(true);
                    break;
                }
                case FORCE_OFFLINE: {
                    event.getConnection().setOnlineMode(false);
                }
            }
        });
    }

    private void setField(PendingConnection connection, String fieldName, Object value, boolean failOnNotFound) throws NoSuchFieldException {
        Class clazz = connection.getClass();
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(connection, value);
        }
        catch (NoSuchFieldException e) {
            if (!failOnNotFound) {
                return;
            }
            Logger logger = ((BungeeCordLibreLogin)this.plugin).getLogger();
            logger.error("The " + fieldName + " field was not found in the PendingConnection class, please report this to the developer. And attach the class summary below.");
            logger.error("-- BEGIN CLASS SUMMARY --");
            logger.error("Class: " + clazz.getName());
            for (Field field : clazz.getDeclaredFields()) {
                logger.error(field.getType().getName() + ": " + field.getName());
            }
            logger.error("-- END CLASS SUMMARY --");
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler(priority=-64)
    public void onProfileRequest(LoginEvent event) {
        if (((BungeeCordLibreLogin)this.plugin).fromFloodgate(event.getConnection().getUniqueId())) {
            return;
        }
        User profile = ((BungeeCordLibreLogin)this.plugin).getDatabaseProvider().getByName(event.getConnection().getName());
        PendingConnection connection = event.getConnection();
        try {
            this.setField(connection, "uniqueId", profile.getUuid(), true);
            this.setField(connection, "rewriteId", profile.getUuid(), false);
        }
        catch (NoSuchFieldException e) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=64)
    public void chooseServer(ServerConnectEvent event) {
        if (!event.getReason().equals((Object)ServerConnectEvent.Reason.JOIN_PROXY)) {
            return;
        }
        BiHolder server = this.chooseServer(event.getPlayer(), null, null);
        if (server.value() == null) {
            event.getPlayer().disconnect(((BungeeCordLibreLogin)this.plugin).getSerializer().serialize((Component)((BungeeCordLibreLogin)this.plugin).getMessages().getMessage("kick-no-" + (server.key() != false ? "lobby" : "limbo"), new String[0])));
        } else {
            event.setTarget((ServerInfo)server.value());
        }
    }

    @EventHandler(priority=-32)
    public void onKick(ServerKickEvent event) {
        Component reason = ((BungeeCordLibreLogin)this.plugin).getSerializer().deserialize(event.getKickReasonComponent());
        Component message = ((BungeeCordLibreLogin)this.plugin).getMessages().getMessage("info-kick", new String[0]).replaceText(builder -> builder.matchLiteral("%reason%").replacement((ComponentLike)reason));
        ProxiedPlayer player = event.getPlayer();
        Audience audience = this.platformHandle.getAudienceForPlayer(event.getPlayer());
        if (event.getState() == ServerKickEvent.State.CONNECTED) {
            if (!((BungeeCordLibreLogin)this.plugin).getConfiguration().get(ConfigurationKeys.FALLBACK).booleanValue()) {
                event.setKickReasonComponent(((BungeeCordLibreLogin)this.plugin).getSerializer().serialize(message));
                event.setCancelled(false);
            } else {
                try {
                    ServerInfo server = (ServerInfo)((BungeeCordLibreLogin)this.plugin).getServerHandler().chooseLobbyServer(((BungeeCordLibreLogin)this.plugin).getDatabaseProvider().getByUUID(player.getUniqueId()), player, false, true);
                    if (server == null) {
                        throw new NoSuchElementException();
                    }
                    event.setCancelled(true);
                    event.setCancelServer(server);
                }
                catch (NoSuchElementException | EventCancelledException e) {
                    event.setKickReasonComponent(((BungeeCordLibreLogin)this.plugin).getSerializer().serialize(message));
                    event.setCancelled(false);
                }
            }
        } else {
            audience.sendMessage(message);
        }
    }
}

