/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.bungeecord;

import co.aikar.commands.BungeeCommandIssuer;
import co.aikar.commands.BungeeCommandManager;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import xyz.kyngs.librelogin.api.PlatformHandle;
import xyz.kyngs.librelogin.api.database.User;
import xyz.kyngs.librelogin.api.event.exception.EventCancelledException;
import xyz.kyngs.librelogin.api.integration.LimboIntegration;
import xyz.kyngs.librelogin.bungeecord.Blockers;
import xyz.kyngs.librelogin.bungeecord.BungeeCordBootstrap;
import xyz.kyngs.librelogin.bungeecord.BungeeCordListener;
import xyz.kyngs.librelogin.bungeecord.BungeeCordLogger;
import xyz.kyngs.librelogin.bungeecord.BungeeCordPlatformHandle;
import xyz.kyngs.librelogin.bungeecord.integration.BungeeNanoLimboIntegration;
import xyz.kyngs.librelogin.common.AuthenticLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.image.AuthenticImageProjector;
import xyz.kyngs.librelogin.common.image.protocolize.ProtocolizeImageProjector;
import xyz.kyngs.librelogin.common.util.CancellableTask;
import xyz.kyngs.librelogin.lib.jetbrains.annotations.Nullable;
import xyz.kyngs.librelogin.lib.metrics.bungeecord.Metrics;
import xyz.kyngs.librelogin.lib.metrics.charts.CustomChart;

public class BungeeCordLibreLogin
extends AuthenticLibreLogin<ProxiedPlayer, ServerInfo> {
    private final BungeeCordBootstrap bootstrap;
    private BungeeAudiences adventure;
    @Nullable
    private RedisBungeeAPI redisBungee;
    @Nullable
    private LimboIntegration<ServerInfo> limboIntegration;
    private BungeeComponentSerializer serializer;

    public BungeeCordLibreLogin(BungeeCordBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    protected BungeeCordBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public BungeeComponentSerializer getSerializer() {
        return this.serializer;
    }

    public BungeeAudiences getAdventure() {
        return this.adventure;
    }

    @Override
    protected void enable() {
        this.adventure = BungeeAudiences.create((Plugin)this.bootstrap);
        this.serializer = BungeeComponentSerializer.of((GsonComponentSerializer)GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().build(), (LegacyComponentSerializer)LegacyComponentSerializer.builder().flattener(this.adventure.flattener()).build());
        if (this.bootstrap.getProxy().getPluginManager().getPlugin("RedisBungee") != null) {
            this.redisBungee = RedisBungeeAPI.getRedisBungeeApi();
        }
        super.enable();
        this.bootstrap.getProxy().getPluginManager().registerListener((Plugin)this.bootstrap, (Listener)new Blockers(this));
        this.bootstrap.getProxy().getPluginManager().registerListener((Plugin)this.bootstrap, (Listener)new BungeeCordListener(this));
    }

    @Override
    protected void disable() {
        super.disable();
        if (this.adventure != null) {
            this.adventure.close();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bootstrap.getResourceAsStream(name);
    }

    @Override
    public File getDataFolder() {
        return this.bootstrap.getDataFolder();
    }

    @Override
    protected PlatformHandle<ProxiedPlayer, ServerInfo> providePlatformHandle() {
        return new BungeeCordPlatformHandle(this);
    }

    @Override
    protected xyz.kyngs.librelogin.api.Logger provideLogger() {
        return new BungeeCordLogger(this.bootstrap, () -> this.getConfiguration().get(ConfigurationKeys.DEBUG));
    }

    @Override
    public CommandManager<?, ?, ?, ?, ?, ?> provideManager() {
        return new BungeeCommandManager((Plugin)this.bootstrap);
    }

    @Override
    public ProxiedPlayer getPlayerFromIssuer(CommandIssuer issuer) {
        BungeeCommandIssuer bungee = (BungeeCommandIssuer)issuer;
        return bungee.getPlayer();
    }

    @Override
    public void authorize(ProxiedPlayer player, User user, Audience audience) {
        try {
            ServerInfo server = (ServerInfo)this.getServerHandler().chooseLobbyServer(user, player, true, false);
            if (server != null) {
                player.connect(server);
            } else {
                player.disconnect(this.serializer.serialize((Component)this.getMessages().getMessage("kick-no-lobby", new String[0])));
            }
        }
        catch (EventCancelledException eventCancelledException) {
            // empty catch block
        }
    }

    @Override
    public CancellableTask delay(Runnable runnable, long delayInMillis) {
        ScheduledTask task = this.bootstrap.getProxy().getScheduler().schedule((Plugin)this.bootstrap, runnable, delayInMillis, TimeUnit.MILLISECONDS);
        return () -> ((ScheduledTask)task).cancel();
    }

    @Override
    public CancellableTask repeat(Runnable runnable, long delayInMillis, long repeatInMillis) {
        ScheduledTask task = this.bootstrap.getProxy().getScheduler().schedule((Plugin)this.bootstrap, runnable, delayInMillis, repeatInMillis, TimeUnit.MILLISECONDS);
        return () -> ((ScheduledTask)task).cancel();
    }

    @Override
    public boolean pluginPresent(String pluginName) {
        return this.bootstrap.getProxy().getPluginManager().getPlugin(pluginName) != null;
    }

    @Override
    protected AuthenticImageProjector<ProxiedPlayer, ServerInfo> provideImageProjector() {
        if (this.pluginPresent("Protocolize")) {
            ProtocolizeImageProjector<ProxiedPlayer, ServerInfo> projector = new ProtocolizeImageProjector<ProxiedPlayer, ServerInfo>(this);
            if (!projector.compatible()) {
                this.getLogger().warn("Detected protocolize, however with incompatible version (2.2.2), please upgrade or downgrade.");
                return null;
            }
            this.getLogger().info("Detected Protocolize, enabling 2FA...");
            return new ProtocolizeImageProjector<ProxiedPlayer, ServerInfo>(this);
        }
        this.getLogger().warn("Protocolize not found, some features (e.g. 2FA) will not work!");
        return null;
    }

    @Override
    public String getVersion() {
        return this.bootstrap.getDescription().getVersion();
    }

    @Override
    public boolean isPresent(UUID uuid) {
        return this.redisBungee != null ? this.redisBungee.isPlayerOnline(uuid) : this.bootstrap.getProxy().getPlayer(uuid) != null;
    }

    @Override
    public boolean multiProxyEnabled() {
        return this.redisBungee != null;
    }

    @Override
    public ProxiedPlayer getPlayerForUUID(UUID uuid) {
        return this.bootstrap.getProxy().getPlayer(uuid);
    }

    @Override
    protected void initMetrics(CustomChart ... charts) {
        Metrics metrics = new Metrics((Plugin)this.bootstrap, 17982);
        for (CustomChart chart : charts) {
            metrics.addCustomChart(chart);
        }
    }

    @Override
    public Audience getAudienceFromIssuer(CommandIssuer issuer) {
        return this.adventure.sender((CommandSender)issuer.getIssuer());
    }

    @Override
    protected Logger getSimpleLogger() {
        return this.bootstrap.getProxy().getLogger();
    }

    @Override
    @Nullable
    public LimboIntegration<ServerInfo> getLimboIntegration() {
        if (this.pluginPresent("NanoLimboBungee") && this.limboIntegration == null) {
            this.limboIntegration = new BungeeNanoLimboIntegration(this.bootstrap.getProxy().getPluginManager().getPlugin("NanoLimboBungee").getClass().getClassLoader(), this.getConfiguration().get(ConfigurationKeys.LIMBO_PORT_RANGE));
        }
        return this.limboIntegration;
    }
}

