/*
 * Decompiled with CFR 0.152.
 */
package xyz.kyngs.librelogin.bungeecord;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import xyz.kyngs.librelogin.api.authorization.AuthorizationProvider;
import xyz.kyngs.librelogin.bungeecord.BungeeCordLibreLogin;
import xyz.kyngs.librelogin.common.config.ConfigurationKeys;
import xyz.kyngs.librelogin.common.config.HoconPluginConfiguration;

public class Blockers
implements Listener {
    private final AuthorizationProvider<ProxiedPlayer> authorizationProvider;
    private final HoconPluginConfiguration configuration;
    private final BungeeCordLibreLogin plugin;

    public Blockers(BungeeCordLibreLogin plugin) {
        this.authorizationProvider = plugin.getAuthorizationProvider();
        this.configuration = plugin.getConfiguration();
        this.plugin = plugin;
    }

    @EventHandler(priority=-64)
    public void onChat(ChatEvent event) {
        ProxiedPlayer player;
        if (event.isCommand()) {
            this.onCommand(event);
            return;
        }
        Connection connection = event.getSender();
        if (connection instanceof ProxiedPlayer && (!this.authorizationProvider.isAuthorized(player = (ProxiedPlayer)connection) || this.authorizationProvider.isAwaiting2FA(player))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=-64)
    public void onCommand(ChatEvent event) {
        Connection connection = event.getSender();
        if (!(connection instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)connection;
        if (this.authorizationProvider.isAuthorized(player) && !this.authorizationProvider.isAwaiting2FA(player)) {
            return;
        }
        String command = event.getMessage().substring(1).split(" ")[0];
        for (String allowed : this.configuration.get(ConfigurationKeys.ALLOWED_COMMANDS_WHILE_UNAUTHORIZED)) {
            if (!command.equals(allowed)) continue;
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=-64)
    public void onServerConnect(ServerConnectEvent event) {
        if (!this.authorizationProvider.isAuthorized(event.getPlayer()) && event.getReason() != ServerConnectEvent.Reason.JOIN_PROXY) {
            event.setCancelled(true);
        } else if (this.authorizationProvider.isAwaiting2FA(event.getPlayer()) && !this.configuration.get(ConfigurationKeys.LIMBO).contains(event.getTarget().getName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=-64)
    public void onServerKick(ServerKickEvent event) {
        if (!this.authorizationProvider.isAuthorized(event.getPlayer()) || this.authorizationProvider.isAwaiting2FA(event.getPlayer())) {
            BaseComponent[] reason = event.getKickReasonComponent();
            if (reason == null) {
                event.getPlayer().disconnect("Limbo not running");
            } else {
                event.getPlayer().disconnect(reason);
            }
        }
    }
}

