/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class WhitelistUtils {
    public static boolean addPlayer(UUID uuid, String username, SpigotVersionSpecificMethods versionSpecificMethods) {
        GameProfile profile = new GameProfile(uuid, username);
        OfflinePlayer player = WhitelistUtils.getOfflinePlayer(profile);
        if (player.isWhitelisted()) {
            return false;
        }
        WhitelistUtils.setWhitelist(player, true, versionSpecificMethods);
        return true;
    }

    public static boolean removePlayer(UUID uuid, String username, SpigotVersionSpecificMethods versionSpecificMethods) {
        GameProfile profile = new GameProfile(uuid, username);
        OfflinePlayer player = WhitelistUtils.getOfflinePlayer(profile);
        if (!player.isWhitelisted()) {
            return false;
        }
        WhitelistUtils.setWhitelist(player, false, versionSpecificMethods);
        return true;
    }

    static void setWhitelist(OfflinePlayer player, boolean whitelist, SpigotVersionSpecificMethods versionSpecificMethods) {
        versionSpecificMethods.maybeSchedule(() -> player.setWhitelisted(whitelist), true);
    }

    static OfflinePlayer getOfflinePlayer(GameProfile profile) {
        if (ClassNames.CRAFT_NEW_OFFLINE_PLAYER_CONSTRUCTOR != null) {
            Object nameAndId = ReflectionUtils.newInstance(ClassNames.NAME_AND_ID_CONSTRUCTOR, profile);
            return ReflectionUtils.newInstance(ClassNames.CRAFT_NEW_OFFLINE_PLAYER_CONSTRUCTOR, Bukkit.getServer(), nameAndId);
        }
        return ReflectionUtils.newInstance(ClassNames.CRAFT_OFFLINE_PLAYER_CONSTRUCTOR, Bukkit.getServer(), profile);
    }
}

