/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class SpigotVersionSpecificMethods {
    private static final Method GET_SPIGOT = ReflectionUtils.getMethod(Player.class, "spigot", new Class[0]);
    private static final Method OLD_GET_LOCALE = ReflectionUtils.getMethod(Player.Spigot.class, "getLocale", new Class[0]);
    private static final boolean NEW_VISIBILITY = null != ReflectionUtils.getMethod(Player.class, "hidePlayer", Plugin.class, Player.class);
    private static final Method NEW_PROPERTY_VALUE = ReflectionUtils.getMethod(Property.class, "value", new Class[0]);
    private static final Method NEW_PROPERTY_SIGNATURE = ReflectionUtils.getMethod(Property.class, "signature", new Class[0]);
    private static final Method NEW_GAME_PROFILE_PROPERTIES = ReflectionUtils.getMethod(GameProfile.class, "properties", new Class[0]);
    private static final Constructor<GameProfile> RECORD_GAME_PROFILE_CONSTRUCTOR = ReflectionUtils.getConstructor(GameProfile.class, true, UUID.class, String.class, PropertyMap.class);
    private static final Constructor<PropertyMap> IMMUTABLE_PROPERTY_MAP_CONSTRUCTOR = PropertyMap.class.getConstructors()[0];
    private static final Method MULTIMAP_FROM_MAP;
    private static final Field PROFILE_NAME_FIELD;
    private static final Field PROFILE_UUID_FIELD;
    private final SpigotPlugin plugin;

    public SpigotVersionSpecificMethods(SpigotPlugin plugin) {
        this.plugin = plugin;
    }

    public GameProfile createGameProfile(GameProfile oldProfile, Property textureProperty) {
        String name = (String)ReflectionUtils.getValue((Object)oldProfile, PROFILE_NAME_FIELD);
        UUID uuid = (UUID)ReflectionUtils.getValue((Object)oldProfile, PROFILE_UUID_FIELD);
        return this.createGameProfile(uuid, name, textureProperty);
    }

    public GameProfile createGameProfile(UUID uuid, String name, Property texturesProperty) {
        if (RECORD_GAME_PROFILE_CONSTRUCTOR != null && IMMUTABLE_PROPERTY_MAP_CONSTRUCTOR != null && texturesProperty != null) {
            HashMap<String, Property> properties = new HashMap<String, Property>();
            properties.put("textures", texturesProperty);
            Object multimap = ReflectionUtils.invoke(null, MULTIMAP_FROM_MAP, properties);
            return ReflectionUtils.newInstanceOrThrow(RECORD_GAME_PROFILE_CONSTRUCTOR, uuid, name, ReflectionUtils.newInstanceOrThrow(IMMUTABLE_PROPERTY_MAP_CONSTRUCTOR, multimap));
        }
        GameProfile profile = new GameProfile(uuid, name);
        if (texturesProperty != null) {
            profile.getProperties().put((Object)"textures", (Object)texturesProperty);
        }
        return profile;
    }

    public String getLocale(Player player) {
        if (OLD_GET_LOCALE == null) {
            return player.getLocale();
        }
        Object spigot = ReflectionUtils.invoke(player, GET_SPIGOT, new Object[0]);
        return (String)ReflectionUtils.castedInvoke(spigot, OLD_GET_LOCALE, new Object[0]);
    }

    public void hideAndShowPlayer(Player on, Player target) {
        if (ClassNames.IS_FOLIA) {
            on.getScheduler().execute((Plugin)this.plugin, () -> this.hideAndShowPlayer0(on, target), null, 0L);
            return;
        }
        this.hideAndShowPlayer0(on, target);
    }

    public SkinApplyEvent.SkinData currentSkin(GameProfile profile) {
        PropertyMap properties = NEW_GAME_PROFILE_PROPERTIES != null ? (PropertyMap)ReflectionUtils.castedInvoke(profile, NEW_GAME_PROFILE_PROPERTIES, new Object[0]) : profile.getProperties();
        for (Property property : properties.get((Object)"textures")) {
            String signature;
            String value;
            if (NEW_PROPERTY_VALUE != null) {
                value = (String)ReflectionUtils.castedInvoke(property, NEW_PROPERTY_VALUE, new Object[0]);
                signature = (String)ReflectionUtils.castedInvoke(property, NEW_PROPERTY_SIGNATURE, new Object[0]);
            } else {
                value = property.getValue();
                signature = property.getSignature();
            }
            if (value.isEmpty()) continue;
            return new SkinDataImpl(value, signature);
        }
        return null;
    }

    public void schedule(Runnable runnable, long delay) {
        if (ClassNames.IS_FOLIA) {
            this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, $ -> runnable.run(), delay * 50L, TimeUnit.MILLISECONDS);
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, runnable, delay);
    }

    private void hideAndShowPlayer0(Player source, Player target) {
        if (NEW_VISIBILITY) {
            source.hidePlayer((Plugin)this.plugin, target);
            source.showPlayer((Plugin)this.plugin, target);
            return;
        }
        source.hidePlayer(target);
        source.showPlayer(target);
    }

    public void maybeSchedule(Runnable runnable) {
        this.maybeSchedule(runnable, false);
    }

    public void maybeSchedule(Runnable runnable, boolean globalContext) {
        if (ClassNames.IS_FOLIA) {
            if (globalContext) {
                this.plugin.getServer().getGlobalRegionScheduler().run((Plugin)this.plugin, task -> runnable.run());
            } else {
                runnable.run();
            }
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, runnable);
    }

    static {
        PROFILE_NAME_FIELD = ReflectionUtils.getField(GameProfile.class, "name");
        PROFILE_UUID_FIELD = ReflectionUtils.getField(GameProfile.class, "id");
        Class<?> multimaps = ReflectionUtils.getClass(String.join((CharSequence)".", "com", "google", "common", "collect", "Multimaps"));
        MULTIMAP_FROM_MAP = ReflectionUtils.getMethod(multimaps, "forMap", Map.class);
    }
}

