/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.lang.reflect.Method;
import java.util.UUID;
import org.geysermc.floodgate.api.packet.PacketHandler;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

public class SpigotProtocolSupportHandler
implements PacketHandler {
    private static final Method getFromChannel;
    private static final Method getLoginProfile;
    private static final Method setName;
    private static final Method setOriginalName;
    private static final Method setUuid;
    private static final Method setOriginalUuid;
    private static final Method getNetworkManagerWrapper;
    private static final Method getPacketListener;
    private static final Method handleLoginStart;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;

    @Inject
    public void register(PacketHandlers packetHandlers) {
        packetHandlers.register(this, ClassNames.LOGIN_START_PACKET);
    }

    @Override
    public Object handle(ChannelHandlerContext ctx, Object packet, boolean serverbound) {
        FloodgatePlayer player = (FloodgatePlayer)ctx.channel().attr(this.playerAttribute).get();
        if (player == null) {
            return packet;
        }
        Object connection = ReflectionUtils.invoke(null, getFromChannel, ctx.channel());
        Object profile = ReflectionUtils.invoke(connection, getLoginProfile, new Object[0]);
        ReflectionUtils.invoke(profile, setName, player.getCorrectUsername());
        ReflectionUtils.invoke(profile, setOriginalName, player.getCorrectUsername());
        ReflectionUtils.invoke(profile, setUuid, player.getCorrectUniqueId());
        ReflectionUtils.invoke(profile, setOriginalUuid, player.getCorrectUniqueId());
        Object temp = ReflectionUtils.invoke(connection, getNetworkManagerWrapper, new Object[0]);
        temp = ReflectionUtils.invoke(temp, getPacketListener, new Object[0]);
        ReflectionUtils.invoke(temp, handleLoginStart, player.getCorrectUsername());
        return packet;
    }

    static {
        Class<?> connectionImpl = ReflectionUtils.getClass("protocolsupport.protocol.ConnectionImpl");
        getFromChannel = ReflectionUtils.getMethod(connectionImpl, "getFromChannel", Channel.class);
        getLoginProfile = ReflectionUtils.getMethod(connectionImpl, "getLoginProfile", new Class[0]);
        Class<?> profile = ReflectionUtils.getClass("protocolsupport.protocol.utils.authlib.LoginProfile");
        setName = ReflectionUtils.getMethod(profile, "setName", String.class);
        setOriginalName = ReflectionUtils.getMethod(profile, "setOriginalName", String.class);
        setUuid = ReflectionUtils.getMethod(profile, "setUUID", UUID.class);
        setOriginalUuid = ReflectionUtils.getMethod(profile, "setOriginalUUID", UUID.class);
        getNetworkManagerWrapper = ReflectionUtils.getMethod(connectionImpl, "getNetworkManagerWrapper", new Class[0]);
        Class<?> networkManagerWrapper = ReflectionUtils.getClass("protocolsupport.zplatform.network.NetworkManagerWrapper");
        getPacketListener = ReflectionUtils.getMethod(networkManagerWrapper, "getPacketListener", new Class[0]);
        Class<?> loginListener = ReflectionUtils.getClass("protocolsupport.protocol.packet.handler.AbstractLoginListener");
        handleLoginStart = ReflectionUtils.getMethod(loginListener, "handleLoginStart", String.class);
    }
}

