/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.UUID;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.handshake.HandshakeHandler;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.util.BedrockData;

public class SpigotHandshakeHandler
implements HandshakeHandler {
    @Inject
    private FloodgateLogger logger;

    @Override
    public void handle(HandshakeData data) {
        if (data.getBedrockData() == null) {
            return;
        }
        BedrockData bedrockData = data.getBedrockData();
        UUID correctUuid = data.getCorrectUniqueId();
        CharSequence[] split = data.getHostname().split("\u0000");
        if (split.length >= 3) {
            if (this.logger.isDebug()) {
                this.logger.info("Replacing hostname arg1 '{}' with '{}' and arg2 '{}' with '{}'", split[1], bedrockData.getIp(), split[2], correctUuid.toString());
            }
            split[1] = bedrockData.getIp();
            split[2] = correctUuid.toString();
        }
        data.setHostname(String.join((CharSequence)"\u0000", split));
    }
}

