/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.shadow.com.google.common.cache.Cache;
import org.geysermc.floodgate.shadow.com.google.common.cache.CacheBuilder;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.util.HttpClient;

@Singleton
public class MojangUtils {
    private final Cache<UUID, SkinApplyEvent.SkinData> SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(500L).build();
    @Inject
    private HttpClient httpClient;
    @Inject
    @Named(value="commonPool")
    private ExecutorService commonPool;

    public CompletableFuture< @NonNull SkinApplyEvent.SkinData> skinFor(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.SKIN_CACHE.get(playerId, () -> this.fetchSkinFor(playerId));
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(exception.getCause());
            }
        }, this.commonPool);
    }

    @NonNull
    private SkinApplyEvent.SkinData fetchSkinFor(UUID playerId) {
        HttpClient.DefaultHttpResponse httpResponse = this.httpClient.get(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", playerId.toString()));
        if (httpResponse.getHttpCode() != 200) {
            return SkinDataImpl.DEFAULT_SKIN;
        }
        JsonObject response = (JsonObject)httpResponse.getResponse();
        if (response == null) {
            return SkinDataImpl.DEFAULT_SKIN;
        }
        JsonArray properties = response.getAsJsonArray("properties");
        if (properties.size() == 0) {
            return SkinDataImpl.DEFAULT_SKIN;
        }
        for (JsonElement property : properties) {
            JsonObject propertyObject;
            if (!property.isJsonObject() || !(propertyObject = property.getAsJsonObject()).has("name") || !propertyObject.has("value") || !propertyObject.has("signature") || !propertyObject.get("name").getAsString().equals("textures")) continue;
            return new SkinDataImpl(propertyObject.get("value").getAsString(), propertyObject.get("signature").getAsString());
        }
        return SkinDataImpl.DEFAULT_SKIN;
    }
}

