/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.skin;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.net.ConnectException;
import java.net.URI;
import javax.net.ssl.SSLException;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinDataImpl;
import org.geysermc.floodgate.skin.SkinUploadManager;
import org.geysermc.floodgate.util.Utils;
import org.geysermc.floodgate.util.WebsocketEventType;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

final class SkinUploadSocket
extends WebSocketClient {
    private static final Gson gson = new Gson();
    private final SkinUploadManager uploadManager;
    private final FloodgateApi api;
    private final SkinApplier applier;
    private final FloodgateLogger logger;
    private final int id;
    private final String verifyCode;
    private int subscribersCount;

    public SkinUploadSocket(int id, String verifyCode, SkinUploadManager uploadManager, FloodgateApi api, SkinApplier applier, FloodgateLogger logger) {
        super(SkinUploadSocket.getWebsocketUri(id, verifyCode));
        this.id = id;
        this.verifyCode = verifyCode;
        this.uploadManager = uploadManager;
        this.api = api;
        this.applier = applier;
        this.logger = logger;
    }

    private static URI getWebsocketUri(int id, String verifyCode) {
        try {
            return new URI("wss://api.geysermc.org/ws?subscribed_to=" + id + "&verify_code=" + verifyCode);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while creating uri. Id = " + id + ", verify_code = " + verifyCode, exception);
        }
    }

    @Override
    public void onOpen(ServerHandshake ignored) {
        this.setConnectionLostTimeout(11);
    }

    @Override
    public void onMessage(String data) {
        int typeId;
        WebsocketEventType type;
        JsonObject message = (JsonObject)gson.fromJson(data, JsonObject.class);
        if (message.has("error")) {
            this.logger.error("Skin uploader got an error: {}", message.get("error").getAsString());
        }
        if ((type = WebsocketEventType.fromId(typeId = message.get("event_id").getAsInt())) == null) {
            this.logger.warn("Got unknown type {}. Ensure that Floodgate is up-to-date", typeId);
            return;
        }
        block0 : switch (type) {
            case SUBSCRIBER_COUNT: {
                this.subscribersCount = message.get("subscribers_count").getAsInt();
                break;
            }
            case SKIN_UPLOADED: {
                String xuid = message.get("xuid").getAsString();
                FloodgatePlayer player = this.api.getPlayer(Utils.getJavaUuid(xuid));
                if (player == null) break;
                if (!message.get("success").getAsBoolean()) {
                    this.logger.info("Failed to upload skin for {} ({})", xuid, player.getCorrectUsername());
                    return;
                }
                SkinApplyEvent.SkinData skinData = SkinDataImpl.from(message.getAsJsonObject("data"));
                this.applier.applySkin(player, skinData);
                if (player.isLinked()) break;
                player.addProperty(PropertyKey.SKIN_UPLOADED, (Object)skinData);
                break;
            }
            case LOG_MESSAGE: {
                String logMessage = message.get("message").getAsString();
                switch (message.get("priority").getAsInt()) {
                    case -1: {
                        this.logger.debug("Got a message from skin uploader: " + logMessage, new Object[0]);
                        break block0;
                    }
                    case 0: {
                        this.logger.info("Got a message from skin uploader: " + logMessage, new Object[0]);
                        break block0;
                    }
                    case 1: {
                        this.logger.error("Got a message from skin uploader: " + logMessage, new Object[0]);
                        break block0;
                    }
                }
                this.logger.info(logMessage, new Object[0]);
                break;
            }
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        if (reason != null && !reason.isEmpty()) {
            JsonObject message = (JsonObject)gson.fromJson(reason, JsonObject.class);
            if (message.has("info")) {
                String info = message.get("info").getAsString();
                this.logger.debug("Got disconnected from the skin uploader: {}", info);
            }
            if (message.has("error")) {
                String error = message.get("error").getAsString();
                this.logger.info("Got disconnected from the skin uploader: {}", error);
            }
        }
        this.uploadManager.removeConnection(this.id, this);
    }

    @Override
    public void onError(Exception exception) {
        if (exception instanceof ConnectException || exception instanceof JsonSyntaxException || exception instanceof SSLException) {
            if (this.logger.isDebug()) {
                this.logger.error("[debug] Got an error", exception, new Object[0]);
            }
            return;
        }
        this.logger.error("Got an error", exception, new Object[0]);
    }

    public int getId() {
        return this.id;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public int getSubscribersCount() {
        return this.subscribersCount;
    }
}

