/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.skin;

import org.geysermc.event.Listener;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.event.lifecycle.ShutdownEvent;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.floodgate.shadow.it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import org.geysermc.floodgate.shadow.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinUploadSocket;

@Listener
@Singleton
public final class SkinUploadManager {
    private final Int2ObjectMap<SkinUploadSocket> connections = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
    @Inject
    private FloodgateApi api;
    @Inject
    private SkinApplier applier;
    @Inject
    private FloodgateLogger logger;

    public void addConnectionIfNeeded(int id, String verifyCode) {
        this.connections.computeIfAbsent(id, ignored -> {
            SkinUploadSocket socket = new SkinUploadSocket(id, verifyCode, this, this.api, this.applier, this.logger);
            socket.connect();
            return socket;
        });
    }

    public void removeConnection(int id, SkinUploadSocket socket) {
        this.connections.remove(id, (Object)socket);
    }

    public void closeAllSockets() {
        for (SkinUploadSocket socket : this.connections.values()) {
            socket.close();
        }
        this.connections.clear();
    }

    @Subscribe
    public void onShutdown(ShutdownEvent ignored) {
        this.closeAllSockets();
    }
}

