/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.org.incendo.cloud.execution;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.org.incendo.cloud.Command;
import org.geysermc.floodgate.shadow.org.incendo.cloud.CommandTree;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandContext;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandInput;
import org.geysermc.floodgate.shadow.org.incendo.cloud.exception.CommandExecutionException;
import org.geysermc.floodgate.shadow.org.incendo.cloud.exception.CommandParseException;
import org.geysermc.floodgate.shadow.org.incendo.cloud.execution.CommandResult;
import org.geysermc.floodgate.shadow.org.incendo.cloud.execution.ExecutionCoordinator;
import org.geysermc.floodgate.shadow.org.incendo.cloud.services.State;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.Suggestion;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.SuggestionMapper;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.Suggestions;
import org.geysermc.floodgate.shadow.org.incendo.cloud.type.tuple.Pair;

@API(status=API.Status.INTERNAL, consumers={"org.geysermc.floodgate.shadow.org.incendo.cloud.*"})
final class ExecutionCoordinatorImpl<C>
implements ExecutionCoordinator<C> {
    static final Executor NON_SCHEDULING_EXECUTOR = new NonSchedulingExecutor();
    private final @NonNull Executor parsingExecutor;
    private final @NonNull Executor suggestionsExecutor;
    private final @NonNull Executor defaultExecutionExecutor;
    private final @Nullable Semaphore executionLock;

    ExecutionCoordinatorImpl(@Nullable Executor parsingExecutor, @Nullable Executor suggestionsExecutor, @Nullable Executor defaultExecutionExecutor, boolean syncExecution) {
        this.parsingExecutor = ExecutionCoordinatorImpl.orRunNow(parsingExecutor);
        this.suggestionsExecutor = ExecutionCoordinatorImpl.orRunNow(suggestionsExecutor);
        this.defaultExecutionExecutor = ExecutionCoordinatorImpl.orRunNow(defaultExecutionExecutor);
        this.executionLock = syncExecution ? new Semaphore(1) : null;
    }

    private static @NonNull Executor orRunNow(@Nullable Executor e) {
        return e == null ? ExecutionCoordinator.nonSchedulingExecutor() : e;
    }

    @Override
    public @NonNull CompletableFuture<CommandResult<C>> coordinateExecution(@NonNull CommandTree<C> commandTree, @NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        return ((CompletableFuture)commandTree.parse(commandContext, commandInput, this.parsingExecutor).thenApplyAsync(command -> {
            boolean passedPostprocessing = commandTree.commandManager().postprocessContext(commandContext, command) == State.ACCEPTED;
            return Pair.of(command, passedPostprocessing);
        }, this.parsingExecutor)).thenComposeAsync(preprocessResult -> {
            if (!((Boolean)preprocessResult.second()).booleanValue()) {
                return CompletableFuture.completedFuture(CommandResult.of(commandContext));
            }
            if (this.executionLock != null) {
                try {
                    this.executionLock.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            CompletionStage commandResultFuture = null;
            try {
                commandResultFuture = ((CompletableFuture)((Command)preprocessResult.first()).commandExecutionHandler().executeFuture(commandContext).exceptionally(exception -> {
                    Throwable workingException = exception instanceof CompletionException ? exception.getCause() : exception;
                    if (workingException instanceof CommandParseException) {
                        throw (CommandParseException)workingException;
                    }
                    if (workingException instanceof CommandExecutionException) {
                        throw (CommandExecutionException)workingException;
                    }
                    throw new CommandExecutionException(workingException, commandContext);
                })).thenApply(v -> CommandResult.of(commandContext));
            }
            finally {
                if (this.executionLock != null) {
                    if (commandResultFuture != null) {
                        ((CompletableFuture)commandResultFuture).whenComplete(($, $$) -> this.executionLock.release());
                    } else {
                        this.executionLock.release();
                    }
                }
            }
            return commandResultFuture;
        }, this.defaultExecutionExecutor);
    }

    @Override
    public <S extends Suggestion> @NonNull CompletableFuture<@NonNull Suggestions<C, S>> coordinateSuggestions(@NonNull CommandTree<C> commandTree, @NonNull CommandContext<C> context, @NonNull CommandInput commandInput, @NonNull SuggestionMapper<S> mapper) {
        return commandTree.getSuggestions(context, commandInput, mapper, this.suggestionsExecutor);
    }

    private static final class NonSchedulingExecutor
    implements Executor {
        private NonSchedulingExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

