/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.util.LanguageManager;

public final class SpigotListener
implements Listener {
    @Inject
    private SimpleFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID uniqueId = event.getPlayer().getUniqueId();
        FloodgatePlayer player = this.api.getPlayer(uniqueId);
        if (player != null) {
            this.logger.translatedInfo("floodgate.ingame.login_name", player.getCorrectUsername(), player.getCorrectUniqueId());
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }
}

