/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.Listener;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.event.lifecycle.ShutdownEvent;
import org.geysermc.floodgate.link.DisabledPlayerLink;
import org.geysermc.floodgate.link.GlobalPlayerLinking;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Injector;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.shadow.com.google.inject.name.Names;
import org.geysermc.floodgate.util.InjectorHolder;
import org.geysermc.floodgate.util.Utils;

@Listener
@Singleton
public final class PlayerLinkHolder {
    @Inject
    private Injector injector;
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="dataDirectory")
    private Path dataDirectory;
    private URLClassLoader classLoader;
    private PlayerLink instance;

    public @NonNull PlayerLink load() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = this.load0();
        return this.instance;
    }

    private @NonNull PlayerLink load0() {
        String databaseName;
        List files;
        if (this.config == null) {
            throw new IllegalStateException("Config cannot be null!");
        }
        FloodgateConfig.PlayerLinkConfig linkConfig = this.config.getPlayerLink();
        if (!linkConfig.isEnabled()) {
            return new DisabledPlayerLink();
        }
        try (Stream<Path> list = Files.list(this.dataDirectory);){
            files = list.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".jar")).collect(Collectors.toList());
        }
        catch (IOException exception) {
            this.logger.error("Failed to list possible database implementations", exception, new Object[0]);
            return new DisabledPlayerLink();
        }
        if (linkConfig.isEnableGlobalLinking() && (files.isEmpty() || !linkConfig.isEnableOwnLinking())) {
            return this.injector.getInstance(GlobalPlayerLinking.class);
        }
        if (files.isEmpty()) {
            this.logger.error("Failed to find a database implementation", new Object[0]);
            return new DisabledPlayerLink();
        }
        Path implementationPath = (Path)files.get(0);
        if (files.size() > 1) {
            boolean found = false;
            databaseName = linkConfig.getType();
            String expectedName = "floodgate-" + databaseName + "-database.jar";
            for (Path path2 : files) {
                if (!expectedName.equalsIgnoreCase(path2.getFileName().toString())) continue;
                implementationPath = path2;
                found = true;
            }
            if (!found) {
                this.logger.error("Failed to find an implementation for type: {}", linkConfig.getType());
                return new DisabledPlayerLink();
            }
        } else {
            String name = implementationPath.getFileName().toString();
            if (!Utils.isValidDatabaseName(name)) {
                this.logger.error("Found database {} but the name doesn't match {}", name, "^floodgate-[a-zA-Z0-9_]{0,16}-database.jar$");
                return new DisabledPlayerLink();
            }
            int firstSplit = name.indexOf(45) + 1;
            databaseName = name.substring(firstSplit, name.indexOf(45, firstSplit));
        }
        boolean init = true;
        try {
            String mainClassName;
            JsonObject dbInitConfig;
            URL pluginUrl = implementationPath.toUri().toURL();
            this.classLoader = new URLClassLoader(new URL[]{pluginUrl}, PlayerLinkHolder.class.getClassLoader());
            try (InputStream linkConfigStream = this.classLoader.getResourceAsStream("init.json");){
                Objects.requireNonNull(linkConfigStream, "Implementation should have an init file");
                dbInitConfig = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(linkConfigStream), JsonObject.class);
                mainClassName = dbInitConfig.get("mainClass").getAsString();
            }
            Class<?> mainClass = this.classLoader.loadClass(mainClassName);
            init = false;
            InjectorHolder injectorHolder = new InjectorHolder();
            Injector linkInjector = this.injector.createChildInjector(binder -> {
                binder.bind(String.class).annotatedWith(Names.named("databaseName")).toInstance(databaseName);
                binder.bind(ClassLoader.class).annotatedWith(Names.named("databaseClassLoader")).toInstance(this.classLoader);
                binder.bind(JsonObject.class).annotatedWith(Names.named("databaseInitData")).toInstance(dbInitConfig);
                binder.bind(InjectorHolder.class).toInstance(injectorHolder);
            });
            injectorHolder.set(linkInjector);
            PlayerLink instance = (PlayerLink)linkInjector.getInstance(mainClass);
            if (linkConfig.isEnableGlobalLinking()) {
                GlobalPlayerLinking linking = linkInjector.getInstance(GlobalPlayerLinking.class);
                linking.setDatabaseImpl(instance);
                linking.load();
                return linking;
            }
            instance.load();
            return instance;
        }
        catch (ClassCastException exception) {
            this.logger.error("The database implementation ({}) doesn't extend the PlayerLink class!", implementationPath.getFileName().toString(), exception);
            return new DisabledPlayerLink();
        }
        catch (Exception exception) {
            if (init) {
                this.logger.error("Error while initialising database jar", exception, new Object[0]);
            } else {
                this.logger.error("Error while loading database jar", exception, new Object[0]);
            }
            return new DisabledPlayerLink();
        }
    }

    @Subscribe
    public void onShutdown(ShutdownEvent ignored) throws Exception {
        this.instance.stop();
        if (this.classLoader != null) {
            this.classLoader.close();
        }
    }
}

